"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnomaliesUserTableColumnsCurated = exports.getAnomaliesUserTableColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../../tables/helpers");
var _create_compound_key = require("./create_compound_key");
var _links = require("../../links");
var i18n = _interopRequireWildcard(require("./translations"));
var _model = require("../../../../explore/users/store/model");
var _get_anomalies_table_columns = require("./get_anomalies_table_columns");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAnomaliesUserTableColumns = (startDate, endDate) => [{
  name: i18n.USER_NAME,
  field: 'userName',
  sortable: true,
  render: (userName, anomaliesByUser) => (0, _helpers.getRowItemsWithActions)({
    values: [userName],
    fieldName: 'user.name',
    idPrefix: `anomalies-user-table-userName-${(0, _create_compound_key.createCompoundAnomalyKey)(anomaliesByUser.anomaly)}-userName`,
    render: item => /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
      userName: item
    })
  })
}, ...(0, _get_anomalies_table_columns.getAnomaliesDefaultTableColumns)(startDate, endDate)];
exports.getAnomaliesUserTableColumns = getAnomaliesUserTableColumns;
const getAnomaliesUserTableColumnsCurated = (pageType, startDate, endDate) => {
  const columns = getAnomaliesUserTableColumns(startDate, endDate);

  // Columns to exclude from user details pages
  if (pageType === _model.UsersType.details) {
    return columns.filter(column => column.name !== i18n.USER_NAME);
  } else {
    return columns;
  }
};
exports.getAnomaliesUserTableColumnsCurated = getAnomaliesUserTableColumnsCurated;