"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityComponent = exports.Entity = void 0;
var _react = _interopRequireDefault(require("react"));
var _cell_actions = require("../cell_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityComponent = ({
  entityName,
  entityValue
}) => {
  return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    data: {
      field: entityName,
      value: entityValue
    },
    triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
    mode: _cell_actions.CellActionsMode.HOVER_DOWN,
    visibleCellActions: 5
  }, `${entityName}: "${entityValue}"`);
};
exports.EntityComponent = EntityComponent;
EntityComponent.displayName = 'EntityComponent';
const Entity = /*#__PURE__*/_react.default.memo(EntityComponent);
exports.Entity = Entity;
Entity.displayName = 'Entity';