"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _unified = _interopRequireDefault(require("unified"));
var _i18nReact = require("@kbn/i18n-react");
var _plugins = require("./plugins");
var _markdown_link = require("./markdown_link");
var _kibana = require("../../lib/kibana");
var _use_license = require("../../hooks/use_license");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MarkdownRendererComponent = ({
  children,
  disableLinks,
  textSize = 'm'
}) => {
  const MarkdownLinkProcessingComponent = (0, _react.useMemo)(
  // eslint-disable-next-line react/display-name
  () => props => /*#__PURE__*/_react.default.createElement(_markdown_link.MarkdownLink, (0, _extends2.default)({}, props, {
    disableLinks: disableLinks
  })), [disableLinks]);
  // Deep clone of the processing plugins to prevent affecting the markdown editor.
  const processingPluginList = (0, _fp.cloneDeep)(_plugins.processingPlugins);
  // This line of code is TS-compatible and it will break if [1][1] change in the future.
  processingPluginList[1][1].components.a = MarkdownLinkProcessingComponent;
  const isPlatinum = (0, _use_license.useLicense)().isAtLeast('platinum');
  const {
    application
  } = (0, _kibana.useKibana)().services;
  const platinumPluginDetected = (0, _react.useMemo)(() => {
    if (isPlatinum === false) {
      const markdownString = String(children);
      return _plugins.platinumOnlyPluginTokens.some(token => {
        const regex = new RegExp(token);
        return regex.test(markdownString);
      });
    } else {
      return false;
    }
  }, [children, isPlatinum]);
  const processor = (0, _react.useMemo)(() => (0, _unified.default)().use(_plugins.parsingPlugins).use(processingPluginList), [processingPluginList]);
  const markdownParseResult = (0, _react.useMemo)(() => {
    try {
      processor.processSync(children);
      return null;
    } catch (err) {
      return String(err.message);
    }
  }, [children, processor]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, platinumPluginDetected && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.PLATINUM_WARNING,
    color: "primary",
    iconType: "lock"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.premiumPluginLinkPrefix",
    defaultMessage: "To use these interactive markdown features, you must {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: application.getUrlForApp('management', {
          path: 'stack/license_management/home'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.markdown.premiumPluginLinkSuffix",
        defaultMessage: "start a trial or upgrade your subscription"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), markdownParseResult !== null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.INVALID_MARKDOWN,
    color: "danger",
    iconType: "error"
  }, markdownParseResult), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    parsingPluginList: _plugins.parsingPlugins,
    processingPluginList: processingPluginList,
    textSize: textSize
  }, children));
};
MarkdownRendererComponent.displayName = 'MarkdownRendererComponent';
const MarkdownRenderer = /*#__PURE__*/(0, _react.memo)(MarkdownRendererComponent);
exports.MarkdownRenderer = MarkdownRenderer;