"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../lib/kibana");
var _external_link = require("./external_link");
var _links_translations = require("./links_translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocLink = ({
  guidePath = 'security',
  docPath,
  linkText
}) => {
  const {
    services
  } = (0, _kibana.useKibana)();
  const {
    ELASTIC_WEBSITE_URL,
    DOC_LINK_VERSION
  } = services.docLinks;
  const url = `${ELASTIC_WEBSITE_URL}guide/en/${guidePath}/${DOC_LINK_VERSION}/${docPath}`;
  const ariaLabel = `${linkText} - ${_links_translations.COMMON_ARIA_LABEL_ENDING}`;
  return /*#__PURE__*/_react.default.createElement(_external_link.ExternalLink, {
    url: url,
    ariaLabel: ariaLabel
  }, linkText);
};

/**
 * A simple text link to documentation.
 */
const DocLinkWrapper = /*#__PURE__*/(0, _react.memo)(DocLink);
exports.DocLink = DocLinkWrapper;