"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withSecuritySolutionLink = exports.useSecuritySolutionLinkProps = exports.useGetSecuritySolutionLinkProps = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _links = require("@kbn/security-solution-navigation/links");
var _use_url_state_query_params = require("../navigation/use_url_state_query_params");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * It returns a function to get the `onClick` and `href` props to use in link components
 * based on the` deepLinkId` and `path` parameters.
 */
const useGetSecuritySolutionLinkProps = () => {
  const getLinkProps = (0, _links.useGetLinkProps)();
  const getUrlStateQueryParams = (0, _use_url_state_query_params.useGetUrlStateQueryParams)();
  const getSecuritySolutionLinkProps = (0, _react.useCallback)(({
    deepLinkId,
    path,
    onClick
  }) => {
    const urlState = getUrlStateQueryParams(deepLinkId);
    return getLinkProps({
      id: deepLinkId,
      path,
      urlState,
      onClick
    });
  }, [getLinkProps, getUrlStateQueryParams]);
  return getSecuritySolutionLinkProps;
};

/**
 * It returns the `onClick` and `href` props to use in link components
 * based on the` deepLinkId` and `path` parameters.
 */
exports.useGetSecuritySolutionLinkProps = useGetSecuritySolutionLinkProps;
const useSecuritySolutionLinkProps = ({
  deepLinkId,
  path,
  onClick
}) => {
  const getSecuritySolutionLinkProps = useGetSecuritySolutionLinkProps();
  const securitySolutionLinkProps = (0, _react.useMemo)(() => getSecuritySolutionLinkProps({
    deepLinkId,
    path,
    onClick
  }), [getSecuritySolutionLinkProps, deepLinkId, path, onClick]);
  return securitySolutionLinkProps;
};
exports.useSecuritySolutionLinkProps = useSecuritySolutionLinkProps;
const withSecuritySolutionLinkProps = WrappedComponent => /*#__PURE__*/_react.default.memo(function WithSecuritySolutionProps({
  deepLinkId,
  ...rest
}) {
  const getUrlStateQueryParams = (0, _use_url_state_query_params.useGetUrlStateQueryParams)();
  const urlState = getUrlStateQueryParams(deepLinkId);
  return /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({
    id: deepLinkId,
    urlState
  }, rest));
});

/**
 * HOC that wraps any Link component and makes it a Security solutions internal navigation Link.
 */
const withSecuritySolutionLink = WrappedComponent => withSecuritySolutionLinkProps((0, _links.withLink)(WrappedComponent));
exports.withSecuritySolutionLink = withSecuritySolutionLink;