"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReputationLinksOverflow = exports.PortContainer = exports.MoreReputationLinksContainer = exports.LinkButton = exports.LinkAnchor = exports.GenericLinkButton = exports.Comma = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _empty_value = require("../empty_value");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkButton = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, props, children);
exports.LinkButton = LinkButton;
const LinkAnchor = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, props, children);
exports.LinkAnchor = LinkAnchor;
const Comma = (0, _styledComponents.default)('span')`
  margin-right: 5px;
  margin-left: 5px;
  &::after {
    content: ' ,';
  }
`;
exports.Comma = Comma;
Comma.displayName = 'Comma';
const GenericLinkButtonComponent = ({
  children,
  Component,
  dataTestSubj,
  href,
  onClick,
  title,
  iconType = 'expand'
}) => {
  return Component ? /*#__PURE__*/_react.default.createElement(Component, {
    "data-test-subj": dataTestSubj,
    href: href,
    iconType: iconType,
    onClick: onClick,
    title: title
  }, title !== null && title !== void 0 ? title : children) : /*#__PURE__*/_react.default.createElement(LinkButton, {
    "data-test-subj": dataTestSubj,
    href: href,
    onClick: onClick
  }, title !== null && title !== void 0 ? title : children);
};
const GenericLinkButton = /*#__PURE__*/_react.default.memo(GenericLinkButtonComponent);
exports.GenericLinkButton = GenericLinkButton;
const PortContainer = _styledComponents.default.div`
  & svg {
    position: relative;
    top: -1px;
  }
`;
exports.PortContainer = PortContainer;
const ReputationLinksOverflow = /*#__PURE__*/_react.default.memo(({
  moreMaxHeight,
  overflowIndexStart = 5,
  render,
  rowItems
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsOpen(currentIsOpen => !currentIsOpen), []);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ,', /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: togglePopover
  }, `+${rowItems.length - overflowIndexStart} `, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.reputationLinks.moreLabel",
    defaultMessage: "More"
  }))), [togglePopover, overflowIndexStart, rowItems.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, rowItems.length > overflowIndexStart && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "popover",
    button: button,
    isOpen: isOpen,
    closePopover: togglePopover,
    repositionOnScroll: true,
    panelClassName: "withHoverActions__popover"
  }, /*#__PURE__*/_react.default.createElement(MoreReputationLinksContainer, {
    render: render,
    rowItems: rowItems,
    moreMaxHeight: moreMaxHeight,
    overflowIndexStart: overflowIndexStart
  })));
});
exports.ReputationLinksOverflow = ReputationLinksOverflow;
ReputationLinksOverflow.displayName = 'ReputationLinksOverflow';
const MoreReputationLinksContainer = /*#__PURE__*/_react.default.memo(({
  moreMaxHeight,
  overflowIndexStart,
  render,
  rowItems
}) => {
  const moreItems = (0, _react.useMemo)(() => rowItems.slice(overflowIndexStart).map((rowItem, index) => {
    var _ref;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      key: `${rowItem}-${index}`
    }, (_ref = render && render(rowItem)) !== null && _ref !== void 0 ? _ref : (0, _empty_value.defaultToEmptyTag)(rowItem));
  }), [overflowIndexStart, render, rowItems]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "more-container",
    className: "eui-yScroll",
    style: {
      maxHeight: moreMaxHeight,
      paddingRight: '2px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    "data-test-subj": "overflow-items"
  }, moreItems));
});
exports.MoreReputationLinksContainer = MoreReputationLinksContainer;
MoreReputationLinksContainer.displayName = 'MoreReputationLinksContainer';