"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUsersDetailsUrl = exports.getTabsOnUsersUrl = exports.getTabsOnUsersDetailsUrl = void 0;
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUsersDetailsUrl = (detailName, search) => `/name/${detailName}${(0, _helpers.appendSearch)(search)}`;
exports.getUsersDetailsUrl = getUsersDetailsUrl;
const getTabsOnUsersDetailsUrl = (detailName, tabName, search) => `/name/${detailName}/${tabName}${(0, _helpers.appendSearch)(search)}`;
exports.getTabsOnUsersDetailsUrl = getTabsOnUsersDetailsUrl;
const getTabsOnUsersUrl = (tabName, search) => `/${tabName}${(0, _helpers.appendSearch)(search)}`;
exports.getTabsOnUsersUrl = getTabsOnUsersUrl;