"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatIndexPatternRequested = exports.ModalInspectQuery = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _sourcerer = require("../../containers/sourcerer");
var _model = require("../../store/sourcerer/model");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyEuiModal = (0, _styledComponents.default)(_eui.EuiModal)`
  width: min(768px, calc(100vw - 16px));
  min-height: 41vh;
  .euiModal__flex {
    width: 60vw;
  }
  .euiCodeBlock {
    height: auto !important;
    max-width: 718px;
  }
`;
MyEuiModal.displayName = 'MyEuiModal';
const parseInspectStrings = function (stringsArray) {
  try {
    return stringsArray.map(objectStringify => JSON.parse(objectStringify));
  } catch {
    return [];
  }
};
const manageStringify = object => {
  try {
    return JSON.stringify(object, null, 2);
  } catch {
    return i18n.SOMETHING_WENT_WRONG;
  }
};
const formatIndexPatternRequested = (indices = []) => {
  if (indices.length === 1 && indices[0] === _constants.NO_ALERT_INDEX) {
    return /*#__PURE__*/_react.default.createElement("i", null, i18n.NO_ALERT_INDEX_FOUND);
  }
  return indices.length > 0 ? indices.filter(i => i !== _constants.NO_ALERT_INDEX).join(', ') : i18n.SOMETHING_WENT_WRONG;
};
exports.formatIndexPatternRequested = formatIndexPatternRequested;
const ModalInspectQuery = ({
  adHocDataViews,
  additionalRequests,
  additionalResponses,
  closeModal,
  inputId,
  request,
  response,
  title
}) => {
  var _inspectRequests$0$in2, _inspectRequests$2, _inspectResponses$, _inspectResponses$2;
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)(inputId === 'timeline' ? _model.SourcererScopeName.timeline : (0, _sourcerer.getScopeFromPath)(pathname));
  const requests = [request, ...(additionalRequests != null ? additionalRequests : [])];
  const responses = [response, ...(additionalResponses != null ? additionalResponses : [])];
  const inspectRequests = parseInspectStrings(requests);
  const inspectResponses = parseInspectStrings(responses);
  const isSourcererPattern = (0, _react.useMemo)(() => {
    var _inspectRequests$0$in, _inspectRequests$;
    return ((_inspectRequests$0$in = (_inspectRequests$ = inspectRequests[0]) === null || _inspectRequests$ === void 0 ? void 0 : _inspectRequests$.index) !== null && _inspectRequests$0$in !== void 0 ? _inspectRequests$0$in : []).every(pattern => selectedPatterns.includes(pattern.trim()));
  }, [inspectRequests, selectedPatterns]);
  const statistics = [{
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "index-pattern-title"
    }, i18n.INDEX_PATTERN, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: i18n.INDEX_PATTERN_DESC,
      type: "iInCircle"
    })),
    description: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "index-pattern-description"
    }, /*#__PURE__*/_react.default.createElement("p", null, formatIndexPatternRequested(adHocDataViews != null && adHocDataViews.length > 0 ? adHocDataViews : (_inspectRequests$0$in2 = (_inspectRequests$2 = inspectRequests[0]) === null || _inspectRequests$2 === void 0 ? void 0 : _inspectRequests$2.index) !== null && _inspectRequests$0$in2 !== void 0 ? _inspectRequests$0$in2 : [])), !isSourcererPattern && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("small", null, /*#__PURE__*/_react.default.createElement("i", {
      "data-test-subj": "not-sourcerer-msg"
    }, i18n.INSPECT_PATTERN_DIFFERENT))))
  }, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "query-time-title"
    }, i18n.QUERY_TIME, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: i18n.QUERY_TIME_DESC,
      type: "iInCircle"
    })),
    description: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "query-time-description"
    }, ((_inspectResponses$ = inspectResponses[0]) === null || _inspectResponses$ === void 0 ? void 0 : _inspectResponses$.took) === 0 ? '0ms' : (_inspectResponses$2 = inspectResponses[0]) !== null && _inspectResponses$2 !== void 0 && _inspectResponses$2.took ? `${(0, _numeral.default)(inspectResponses[0].took).format('0,0')}ms` : i18n.SOMETHING_WENT_WRONG)
  }, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "request-timestamp-title"
    }, i18n.REQUEST_TIMESTAMP, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: i18n.REQUEST_TIMESTAMP_DESC,
      type: "iInCircle"
    })),
    description: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "request-timestamp-description"
    }, new Date().toISOString())
  }];
  const tabs = [{
    id: 'statistics',
    name: 'Statistics',
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      listItems: statistics,
      type: "responsiveColumn",
      columnWidths: [3, 7]
    }))
  }, {
    id: 'request',
    name: 'Request',
    content: inspectRequests.length > 0 ? inspectRequests.map((inspectRequest, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "js",
      fontSize: "m",
      paddingSize: "m",
      color: "dark",
      overflowHeight: 300,
      isCopyable: true
    }, manageStringify(inspectRequest.body)))) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, null, i18n.SOMETHING_WENT_WRONG)
  }, {
    id: 'response',
    name: 'Response',
    content: inspectResponses.length > 0 ? responses.map((responseText, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "js",
      fontSize: "m",
      paddingSize: "m",
      color: "dark",
      overflowHeight: 300,
      isCopyable: true
    }, responseText))) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, null, i18n.SOMETHING_WENT_WRONG)
  }];
  return /*#__PURE__*/_react.default.createElement(MyEuiModal, {
    onClose: closeModal,
    "data-test-subj": "modal-inspect-euiModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, i18n.INSPECT, " ", title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: closeModal,
    fill: true,
    "data-test-subj": "modal-inspect-close"
  }, i18n.CLOSE)));
};
exports.ModalInspectQuery = ModalInspectQuery;