"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Title = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _truncatable_text = require("../truncatable_text");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Header = _styledComponents.default.h1`
  display: grid;
  grid-gap: 12px;
  grid-template-columns: auto auto;
  align-items: center;
  justify-items: start;
  justify-content: start;
`;
Header.displayName = 'Header';
const TitleWrapper = _styledComponents.default.span`
  // Without  min-width: 0, as a flex child, it wouldn't shrink properly
  // and could overflow its parent.
  min-width: 0;
  max-width: 100%;
`;
TitleWrapper.displayName = 'TitleWrapper';
const TitleComponent = ({
  title,
  badgeOptions
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "l"
}, /*#__PURE__*/_react.default.createElement(Header, {
  "data-test-subj": "header-page-title"
}, /*#__PURE__*/_react.default.createElement(TitleWrapper, null, /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
  tooltipContent: title
}, title)), badgeOptions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, badgeOptions.beta ? /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
  label: badgeOptions.text,
  tooltipContent: badgeOptions.tooltip,
  tooltipPosition: "bottom",
  size: badgeOptions.size
}) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: badgeOptions.color || 'hollow',
  title: ""
}, badgeOptions.text))));
const Title = /*#__PURE__*/_react.default.memo(TitleComponent);
exports.Title = Title;