"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PinEventAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("../../../timelines/components/timeline/styles");
var _helpers = require("../../../timelines/components/timeline/body/helpers");
var _user_privileges = require("../user_privileges");
var _ = require(".");
var _pin = require("../../../timelines/components/timeline/pin");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PinEventActionComponent = ({
  ariaLabel,
  isAlert,
  noteIds,
  onPinClicked,
  eventIsPinned,
  timelineType
}) => {
  const {
    kibanaSecuritySolutionsPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const tooltipContent = (0, _react.useMemo)(() => (0, _helpers.getPinTooltip)({
    isPinned: eventIsPinned,
    isAlert,
    eventHasNotes: (0, _helpers.eventHasNotes)(noteIds),
    timelineType
  }), [eventIsPinned, isAlert, noteIds, timelineType]);
  return /*#__PURE__*/_react.default.createElement("div", {
    key: "timeline-action-pin-tool-tip"
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    textAlign: "center",
    width: _.DEFAULT_ACTION_BUTTON_WIDTH
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "timeline-action-pin-tool-tip",
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement(_pin.Pin, {
    ariaLabel: ariaLabel,
    allowUnpinning: !(0, _helpers.eventHasNotes)(noteIds),
    "data-test-subj": "pin-event",
    isDisabled: kibanaSecuritySolutionsPrivileges.crud === false,
    isAlert: isAlert,
    onClick: onPinClicked,
    pinned: eventIsPinned,
    timelineType: timelineType
  }))));
};
PinEventActionComponent.displayName = 'PinEventActionComponent';
const PinEventAction = /*#__PURE__*/_react.default.memo(PinEventActionComponent);
exports.PinEventAction = PinEventAction;