"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTourContext = exports.TourContextProvider = exports.RealTourContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _reactRouterDom = require("react-router-dom");
var _siem_guide_config = require("../../../../common/guided_onboarding/siem_guide_config");
var _helpers = require("../../../helpers");
var _kibana = require("../../lib/kibana");
var _tour_config = require("./tour_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  activeStep: 0,
  endTourStep: () => {},
  incrementStep: () => {},
  isTourShown: () => false,
  setStep: () => {}
};
const TourContext = /*#__PURE__*/(0, _react.createContext)(initialState);
const RealTourContextProvider = ({
  children
}) => {
  var _guidedOnboarding$gui, _guidedOnboarding$gui2, _guidedOnboarding$gui3, _guidedOnboarding$gui4;
  const {
    guidedOnboarding
  } = (0, _kibana.useKibana)().services;
  const isRulesTourActive = (0, _useObservable.default)((_guidedOnboarding$gui = guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui2 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui2 === void 0 ? void 0 : _guidedOnboarding$gui2.isGuideStepActive$(_siem_guide_config.siemGuideId, _tour_config.SecurityStepId.rules).pipe(
  // if no result after 30s the observable will error, but the error handler will just emit false
  (0, _rxjs.timeout)(30000), (0, _rxjs.catchError)(error => (0, _rxjs.of)(false)))) !== null && _guidedOnboarding$gui !== void 0 ? _guidedOnboarding$gui : (0, _rxjs.of)(false), false);
  const isAlertsCasesTourActive = (0, _useObservable.default)((_guidedOnboarding$gui3 = guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui4 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui4 === void 0 ? void 0 : _guidedOnboarding$gui4.isGuideStepActive$(_siem_guide_config.siemGuideId, _tour_config.SecurityStepId.alertsCases).pipe(
  // if no result after 30s the observable will error, but the error handler will just emit false
  (0, _rxjs.timeout)(30000), (0, _rxjs.catchError)(error => (0, _rxjs.of)(false)))) !== null && _guidedOnboarding$gui3 !== void 0 ? _guidedOnboarding$gui3 : (0, _rxjs.of)(false), false);
  const tourStatus = (0, _react.useMemo)(() => ({
    [_tour_config.SecurityStepId.rules]: isRulesTourActive,
    [_tour_config.SecurityStepId.alertsCases]: isAlertsCasesTourActive
  }), [isRulesTourActive, isAlertsCasesTourActive]);
  const isTourShown = (0, _react.useCallback)(tourId => tourStatus[tourId], [tourStatus]);
  const [activeStep, _setActiveStep] = (0, _react.useState)(1);
  const incrementStep = (0, _react.useCallback)(tourId => {
    _setActiveStep(prevState => (prevState >= _tour_config.securityTourConfig[tourId].length ? 0 : prevState) + 1);
  }, []);
  const setStep = (0, _react.useCallback)((tourId, step) => {
    if (step <= _tour_config.securityTourConfig[tourId].length) _setActiveStep(step);
  }, []);
  const [completeStep, setCompleteStep] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (!completeStep || !(guidedOnboarding !== null && guidedOnboarding !== void 0 && guidedOnboarding.guidedOnboardingApi)) {
      return;
    }
    let ignore = false;
    const complete = async () => {
      var _guidedOnboarding$gui5;
      await (guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui5 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui5 === void 0 ? void 0 : _guidedOnboarding$gui5.completeGuideStep(_siem_guide_config.siemGuideId, completeStep));
      if (!ignore) {
        setCompleteStep(null);
        _setActiveStep(1);
      }
    };
    complete();
    return () => {
      ignore = true;
    };
  }, [completeStep, guidedOnboarding]);
  const endTourStep = (0, _react.useCallback)(tourId => {
    setCompleteStep(tourId);
  }, []);
  const context = (0, _react.useMemo)(() => {
    return {
      activeStep,
      endTourStep,
      incrementStep,
      isTourShown,
      setStep
    };
  }, [activeStep, endTourStep, incrementStep, isTourShown, setStep]);
  return /*#__PURE__*/_react.default.createElement(TourContext.Provider, {
    value: context
  }, children);
};
exports.RealTourContextProvider = RealTourContextProvider;
const TourContextProvider = ({
  children
}) => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const ContextProvider = (0, _react.useMemo)(() => (0, _helpers.isTourPath)(pathname) ? RealTourContextProvider : TourContext.Provider, [pathname]);
  return /*#__PURE__*/_react.default.createElement(ContextProvider, {
    value: initialState
  }, children);
};
exports.TourContextProvider = TourContextProvider;
const useTourContext = () => {
  const ctx = (0, _react.useContext)(TourContext);
  if (!ctx) {
    throw new Error('useTourContext can only be called inside of TourContext!');
  }
  return ctx;
};
exports.useTourContext = useTourContext;