"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormatBytes = exports.formatBytes = exports.PreferenceFormattedBytesComponent = exports.PreferenceFormattedBytes = void 0;
var _react = _interopRequireDefault(require("react"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _constants = require("../../../../common/constants");
var _kibana = require("../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatBytes = (value, format) => {
  return (0, _numeral.default)(value).format(format);
};
exports.formatBytes = formatBytes;
const useFormatBytes = () => {
  const [bytesFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_BYTES_FORMAT);
  return value => formatBytes(value, bytesFormat);
};
exports.useFormatBytes = useFormatBytes;
const PreferenceFormattedBytesComponent = ({
  value
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, useFormatBytes()(value));
exports.PreferenceFormattedBytesComponent = PreferenceFormattedBytesComponent;
PreferenceFormattedBytesComponent.displayName = 'PreferenceFormattedBytesComponent';
const PreferenceFormattedBytes = /*#__PURE__*/_react.default.memo(PreferenceFormattedBytesComponent);
exports.PreferenceFormattedBytes = PreferenceFormattedBytes;
PreferenceFormattedBytes.displayName = 'PreferenceFormattedBytes';