"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useControlGroupSyncToLocalStorage = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useControlGroupSyncToLocalStorage = ({
  storageKey,
  shouldSync
}) => {
  const storage = (0, _react.useRef)(new _public.Storage(localStorage));
  const [controlGroupInput, setControlGroupInput] = (0, _react.useState)(() => {
    var _ref;
    return (_ref = storage.current.get(storageKey)) !== null && _ref !== void 0 ? _ref : undefined;
  });
  (0, _react.useEffect)(() => {
    if (shouldSync && controlGroupInput) {
      storage.current.set(storageKey, controlGroupInput);
    }
  }, [shouldSync, controlGroupInput, storageKey]);
  const getStoredControlGroupInput = () => {
    var _ref2;
    return (_ref2 = storage.current.get(storageKey)) !== null && _ref2 !== void 0 ? _ref2 : undefined;
  };
  return {
    controlGroupInput,
    setControlGroupInput,
    getStoredControlGroupInput
  };
};
exports.useControlGroupSyncToLocalStorage = useControlGroupSyncToLocalStorage;