"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedCases = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _tour_config = require("../../guided_onboarding_tour/tour_config");
var _guided_onboarding_tour = require("../../guided_onboarding_tour");
var _kibana = require("../../../lib/kibana");
var _links = require("../../links");
var _constants = require("../../../../../common/constants");
var _insight_accordion = require("./insight_accordion");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches and displays case links of cases that include the associated event (id).
 */
const RelatedCases = /*#__PURE__*/_react.default.memo(({
  eventId
}) => {
  const {
    services: {
      cases
    }
  } = (0, _kibana.useKibana)();
  const toasts = (0, _kibana.useToasts)();
  const [relatedCases, setRelatedCases] = (0, _react.useState)(undefined);
  const [hasError, setHasError] = (0, _react.useState)(false);
  const {
    activeStep,
    isTourShown
  } = (0, _guided_onboarding_tour.useTourContext)();
  const isTourActive = (0, _react.useMemo)(() => activeStep === _tour_config.AlertsCasesTourSteps.viewCase && isTourShown(_tour_config.SecurityStepId.alertsCases), [activeStep, isTourShown]);
  const renderContent = (0, _react.useCallback)(() => renderCaseContent(relatedCases), [relatedCases]);
  const [shouldFetch, setShouldFetch] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (!shouldFetch) {
      return;
    }
    let ignore = false;
    const fetch = async () => {
      let relatedCaseList = [];
      try {
        if (eventId) {
          var _await$cases$api$getR;
          relatedCaseList = (_await$cases$api$getR = await cases.api.getRelatedCases(eventId, {
            owner: _constants.APP_ID
          })) !== null && _await$cases$api$getR !== void 0 ? _await$cases$api$getR : [];
        }
      } catch (error) {
        if (!ignore) {
          setHasError(true);
        }
        toasts.addWarning((0, _translations.CASES_ERROR_TOAST)(error));
      }
      if (!ignore) {
        setRelatedCases(relatedCaseList);
        setShouldFetch(false);
      }
    };
    fetch();
    return () => {
      ignore = true;
    };
  }, [cases.api, eventId, shouldFetch, toasts]);
  (0, _react.useEffect)(() => {
    setShouldFetch(true);
  }, [eventId]);
  let state = 'loading';
  if (hasError) {
    state = 'error';
  } else if (relatedCases) {
    state = 'success';
  }
  return /*#__PURE__*/_react.default.createElement(_insight_accordion.InsightAccordion, {
    prefix: "RelatedCases",
    state: state,
    text: getTextFromState(state, relatedCases === null || relatedCases === void 0 ? void 0 : relatedCases.length),
    renderContent: renderContent,
    forceState: isTourActive ? 'open' : undefined
  });
});
exports.RelatedCases = RelatedCases;
function renderCaseContent(relatedCases = []) {
  const caseCount = relatedCases.length;
  return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "This alert was found in {caseCount}",
    id: "xpack.securitySolution.alertDetails.overview.insights_related_cases_found_content",
    values: {
      caseCount: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.alertDetails.overview.insights_related_cases_found_content_count",
        defaultMessage: "{caseCount} {caseCount, plural, =0 {cases.} =1 {case:} other {cases:}}",
        values: {
          caseCount
        }
      }))
    }
  }), relatedCases.map(({
    id,
    title
  }, index) => id && title ? /*#__PURE__*/_react.default.createElement("span", {
    key: id
  }, ' ', /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
    detailName: id,
    title: title,
    index: index
  }, title), relatedCases[index + 1] ? ',' : '') : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)));
}
RelatedCases.displayName = 'RelatedCases';
function getTextFromState(state, caseCount = 0) {
  switch (state) {
    case 'loading':
      return _translations.CASES_LOADING;
    case 'error':
      return _translations.CASES_ERROR;
    case 'success':
      return (0, _translations.CASES_COUNT)(caseCount);
    default:
      return '';
  }
}