"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedAlertsUpsell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _translations = require("./translations");
var _kibana = require("../../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpsellContainer = _common.euiStyled.div`
  border: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
  padding: 12px;
  border-radius: 6px;
`;
const StyledIcon = (0, _common.euiStyled)(_eui.EuiIcon)`
  margin-right: 10px;
`;
const RelatedAlertsUpsell = /*#__PURE__*/_react.default.memo(() => {
  const {
    application
  } = (0, _kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(UpsellContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StyledIcon, {
    size: "m",
    type: "lock"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "subdued",
    target: "_blank",
    href: application.getUrlForApp('management', {
      path: 'stack/license_management/home'
    })
  }, _translations.INSIGHTS_UPSELL)))));
});
exports.RelatedAlertsUpsell = RelatedAlertsUpsell;
RelatedAlertsUpsell.displayName = 'RelatedAlertsUpsell';