"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNISOLATE = exports.ISOLATED = exports.GET_UNISOLATION_SUCCESS_MESSAGE = exports.GET_ISOLATION_SUCCESS_MESSAGE = exports.CONFIRM = exports.COMMENT_PLACEHOLDER = exports.COMMENT = exports.CANCEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CANCEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.cancel', {
  defaultMessage: 'Cancel'
});
exports.CANCEL = CANCEL;
const CONFIRM = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.confirm', {
  defaultMessage: 'Confirm'
});
exports.CONFIRM = CONFIRM;
const COMMENT = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.comment', {
  defaultMessage: 'Comment'
});
exports.COMMENT = COMMENT;
const COMMENT_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.comment.placeholder', {
  defaultMessage: 'You may leave an optional note here.'
});
exports.COMMENT_PLACEHOLDER = COMMENT_PLACEHOLDER;
const GET_ISOLATION_SUCCESS_MESSAGE = hostName => _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.isolation.successfulMessage', {
  defaultMessage: 'Isolation on host {hostName} successfully submitted',
  values: {
    hostName
  }
});
exports.GET_ISOLATION_SUCCESS_MESSAGE = GET_ISOLATION_SUCCESS_MESSAGE;
const GET_UNISOLATION_SUCCESS_MESSAGE = hostName => _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.unisolate.successfulMessage', {
  defaultMessage: 'Release on host {hostName} successfully submitted',
  values: {
    hostName
  }
});
exports.GET_UNISOLATION_SUCCESS_MESSAGE = GET_UNISOLATION_SUCCESS_MESSAGE;
const UNISOLATE = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostisolation.unisolate', {
  defaultMessage: 'release'
});
exports.UNISOLATE = UNISOLATE;
const ISOLATED = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.isolated', {
  defaultMessage: 'isolated'
});
exports.ISOLATED = ISOLATED;