"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWithCaseDetailsRefresh = exports.CaseDetailsRefreshContext = void 0;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * React Context that can hold the `Ref` that is created an passed to `CaseViewProps['refreshRef`]`, enabling
 * child components to trigger a refresh of a case.
 */
const CaseDetailsRefreshContext = /*#__PURE__*/_react.default.createContext(null);

/**
 * Returns the closes CaseDetails Refresh interface if any. Used in conjuction with `CaseDetailsRefreshContext` component
 *
 * @example
 * // Higher-order component
 * const refreshRef = useRef<CaseViewRefreshPropInterface>(null);
 * return <CaseDetailsRefreshContext.Provider value={refreshRef}>....</CaseDetailsRefreshContext.Provider>
 *
 * // Now, use the hook from a hild component that was rendered inside of `<CaseDetailsRefreshContext.Provider>`
 * const caseDetailsRefresh = useWithCaseDetailsRefresh();
 * ...
 * if (caseDetailsRefresh) {
 *   caseDetailsRefresh.refreshCase();
 * }
 */
exports.CaseDetailsRefreshContext = CaseDetailsRefreshContext;
const useWithCaseDetailsRefresh = () => {
  var _useContext;
  return (_useContext = (0, _react.useContext)(CaseDetailsRefreshContext)) === null || _useContext === void 0 ? void 0 : _useContext.current;
};
exports.useWithCaseDetailsRefresh = useWithCaseDetailsRefresh;