"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _public = require("@kbn/kibana-react-plugin/public");
var _timeline = require("../../../../timelines/store/timeline");
var _constants = require("../../../../../common/constants");
var _right = require("../../../../flyout/document_details/right");
var _data_driven_columns = require("../../../../timelines/components/timeline/body/data_driven_columns");
var _types = require("../../../../../common/types");
var _use_experimental_features = require("../../../hooks/use_experimental_features");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RowActionComponent = ({
  columnHeaders,
  controlColumn,
  data,
  disabled,
  index,
  isEventViewer,
  loadingEventIds,
  onRowSelected,
  onRuleChange,
  pageRowIndex,
  rowIndex,
  selectedEventIds,
  showCheckboxes,
  tabType,
  tableId,
  setEventsLoading,
  setEventsDeleted,
  width,
  refetch
}) => {
  const {
    data: timelineNonEcsData,
    ecs: ecsData,
    _id: eventId,
    _index: indexName
  } = data !== null && data !== void 0 ? data : {};
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [isSecurityFlyoutEnabled] = (0, _public.useUiSetting$)(_constants.ENABLE_EXPANDABLE_FLYOUT_SETTING);
  const isExpandableFlyoutInCreateRuleEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('expandableFlyoutInCreateRuleEnabled');
  const columnValues = (0, _react.useMemo)(() => timelineNonEcsData && columnHeaders.map(header => {
    var _getMappedNonEcsValue;
    return (_getMappedNonEcsValue = (0, _data_driven_columns.getMappedNonEcsValue)({
      data: timelineNonEcsData,
      fieldName: header.id
    })) !== null && _getMappedNonEcsValue !== void 0 ? _getMappedNonEcsValue : [];
  }).join(' '), [columnHeaders, timelineNonEcsData]);
  let showExpandableFlyout;
  if (tableId === _securitysolutionDataTable.TableId.rulePreview) {
    showExpandableFlyout = isSecurityFlyoutEnabled && isExpandableFlyoutInCreateRuleEnabled;
  } else {
    showExpandableFlyout = isSecurityFlyoutEnabled;
  }
  const handleOnEventDetailPanelOpened = (0, _react.useCallback)(() => {
    const updatedExpandedDetail = {
      panelView: 'eventDetail',
      params: {
        eventId: eventId !== null && eventId !== void 0 ? eventId : '',
        indexName: indexName !== null && indexName !== void 0 ? indexName : ''
      }
    };
    if (showExpandableFlyout) {
      openFlyout({
        right: {
          id: _right.DocumentDetailsRightPanelKey,
          params: {
            id: eventId,
            indexName,
            scopeId: tableId
          }
        }
      });
    }
    // TODO remove when https://github.com/elastic/security-team/issues/7462 is merged
    // support of old flyout in cases page
    else if (tableId === _securitysolutionDataTable.TableId.alertsOnCasePage) {
      dispatch(_timeline.timelineActions.toggleDetailPanel({
        ...updatedExpandedDetail,
        id: _types.TimelineId.casePage
      }));
    }
    // TODO remove when https://github.com/elastic/security-team/issues/7462 is merged
    // support of old flyout
    else {
      dispatch(_securitysolutionDataTable.dataTableActions.toggleDetailPanel({
        ...updatedExpandedDetail,
        tabType,
        id: tableId
      }));
    }
  }, [dispatch, eventId, indexName, openFlyout, tabType, tableId, showExpandableFlyout]);
  const Action = controlColumn.rowCellRender;
  if (!timelineNonEcsData || !ecsData || !eventId) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "noData"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Action && /*#__PURE__*/_react.default.createElement(Action, {
    ariaRowindex: pageRowIndex + 1,
    checked: Object.keys(selectedEventIds).includes(eventId),
    columnId: controlColumn.id || '',
    columnValues: columnValues || '',
    data: timelineNonEcsData,
    "data-test-subj": "actions",
    disabled: disabled,
    ecsData: ecsData,
    eventId: eventId,
    index: index,
    isEventViewer: isEventViewer,
    loadingEventIds: loadingEventIds,
    onEventDetailsPanelOpened: handleOnEventDetailPanelOpened,
    onRowSelected: onRowSelected,
    onRuleChange: onRuleChange,
    rowIndex: rowIndex,
    showCheckboxes: showCheckboxes,
    tabType: tabType,
    timelineId: tableId,
    width: width,
    setEventsLoading: setEventsLoading,
    setEventsDeleted: setEventsDeleted,
    refetch: refetch
  }));
};
const RowAction = /*#__PURE__*/_react.default.memo(RowActionComponent);
exports.RowAction = RowAction;