"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartPlaceHolder = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("./common");
var i18n = _interopRequireWildcard(require("./translation"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: ${({
  height
}) => height ? height : '100%'};
  width: ${({
  width
}) => width ? width : '100%'};
  position: relative;
  margin: 0;
`;
FlexGroup.displayName = 'FlexGroup';
const ChartPlaceHolder = ({
  height = '100%',
  width = '100%',
  data
}) => /*#__PURE__*/_react.default.createElement(FlexGroup, {
  justifyContent: "center",
  alignItems: "center",
  height: height,
  width: width
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  textAlign: "center",
  color: "subdued",
  "data-test-subj": "chartHolderText"
}, (0, _common.checkIfAllValuesAreZero)(data) ? i18n.ALL_VALUES_ZEROS_TITLE : i18n.DATA_NOT_AVAILABLE_TITLE)));
exports.ChartPlaceHolder = ChartPlaceHolder;