"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartSettingsPopoverConfiguration = void 0;
var _react = require("react");
var _use_inspect = require("../../../inspect/use_inspect");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultInitialPanelId = 'default-initial-panel';
const useChartSettingsPopoverConfiguration = ({
  onResetStackByFields,
  queryId
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    handleClick
  } = (0, _use_inspect.useInspect)({
    queryId
  });
  const defaultMenuItems = (0, _react.useMemo)(() => [{
    id: defaultInitialPanelId,
    items: [{
      icon: 'inspect',
      name: i18n.INSPECT,
      onClick: () => {
        setIsPopoverOpen(false);
        handleClick();
      }
    }, {
      name: i18n.RESET_GROUP_BY_FIELDS,
      onClick: () => {
        setIsPopoverOpen(false);
        onResetStackByFields();
      }
    }]
  }], [handleClick, onResetStackByFields]);
  return {
    defaultInitialPanelId,
    defaultMenuItems,
    isPopoverOpen,
    setIsPopoverOpen
  };
};
exports.useChartSettingsPopoverConfiguration = useChartSettingsPopoverConfiguration;