"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOptionalSubAggregation = exports.getAlertsRiskQuery = exports.DEFAULT_STACK_BY_FIELD1_SIZE = exports.DEFAULT_STACK_BY_FIELD0_SIZE = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** The maximum number of items to render */
const DEFAULT_STACK_BY_FIELD0_SIZE = 1000;
exports.DEFAULT_STACK_BY_FIELD0_SIZE = DEFAULT_STACK_BY_FIELD0_SIZE;
const DEFAULT_STACK_BY_FIELD1_SIZE = 1000;
exports.DEFAULT_STACK_BY_FIELD1_SIZE = DEFAULT_STACK_BY_FIELD1_SIZE;
const getOptionalSubAggregation = ({
  stackByField1,
  stackByField1Size
}) => stackByField1 != null && !(0, _fp.isEmpty)(stackByField1.trim()) ? {
  stackByField1: {
    terms: {
      field: stackByField1,
      order: {
        _count: 'desc'
      },
      size: stackByField1Size
    }
  }
} : {};
exports.getOptionalSubAggregation = getOptionalSubAggregation;
const getAlertsRiskQuery = ({
  additionalFilters = [],
  from,
  runtimeMappings,
  stackByField0,
  stackByField0Size = DEFAULT_STACK_BY_FIELD0_SIZE,
  stackByField1,
  stackByField1Size = DEFAULT_STACK_BY_FIELD1_SIZE,
  riskSubAggregationField,
  to
}) => ({
  size: 0,
  aggs: {
    stackByField0: {
      terms: {
        field: stackByField0,
        order: {
          _count: 'desc'
        },
        size: stackByField0Size
      },
      aggs: {
        ...getOptionalSubAggregation({
          stackByField1,
          stackByField1Size
        }),
        maxRiskSubAggregation: {
          max: {
            field: riskSubAggregationField
          }
        }
      }
    }
  },
  query: {
    bool: {
      filter: [...additionalFilters, {
        range: {
          '@timestamp': {
            gte: from,
            lte: to
          }
        }
      }]
    }
  },
  runtime_mappings: runtimeMappings
});
exports.getAlertsRiskQuery = getAlertsRiskQuery;