"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssistantTelemetry = void 0;
var _react = require("react");
var _use_conversation_store = require("../use_conversation_store");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAssistantTelemetry = () => {
  const {
    conversations
  } = (0, _use_conversation_store.useConversationStore)();
  const {
    services: {
      telemetry
    }
  } = (0, _kibana.useKibana)();
  const getAnonymizedConversationId = (0, _react.useCallback)(id => {
    var _conversations$id;
    const convo = (_conversations$id = conversations[id]) !== null && _conversations$id !== void 0 ? _conversations$id : {
      isDefault: false
    };
    return convo.isDefault ? id : 'Custom';
  }, [conversations]);
  const reportTelemetry = (0, _react.useCallback)(({
    fn,
    params: {
      conversationId,
      ...rest
    }
  }) => fn({
    ...rest,
    conversationId: getAnonymizedConversationId(conversationId)
  }), [getAnonymizedConversationId]);
  return {
    reportAssistantInvoked: params => reportTelemetry({
      fn: telemetry.reportAssistantInvoked,
      params
    }),
    reportAssistantMessageSent: params => reportTelemetry({
      fn: telemetry.reportAssistantMessageSent,
      params
    }),
    reportAssistantQuickPrompt: params => reportTelemetry({
      fn: telemetry.reportAssistantQuickPrompt,
      params
    })
  };
};
exports.useAssistantTelemetry = useAssistantTelemetry;