"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageText = MessageText;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _custom_codeblock_markdown_plugin = require("../custom_codeblock/custom_codeblock_markdown_plugin");
var _custom_code_block = require("../custom_codeblock/custom_code_block");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANIMATION_TIME = 1;
const cursorCss = (0, _css.css)`
  @keyframes blink {
    0% {
      opacity: 0;
    }
    50% {
      opacity: 1;
    }
    100% {
      opacity: 0;
    }
  }

  animation: blink ${ANIMATION_TIME}s infinite;
  width: 10px;
  height: 16px;
  vertical-align: middle;
  display: inline-block;
  background: ${(0, _eui.transparentize)(_uiTheme.euiThemeVars.euiColorDarkShade, 0.25)};
`;
const Cursor = () => /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": "cursor",
  key: "cursor",
  className: (0, _classnames.default)(cursorCss, 'cursor')
});

// a weird combination of different whitespace chars to make sure it stays
// invisible even when we cannot properly parse the text while still being
// unique
const CURSOR = ` ᠎  `;
const loadingCursorPlugin = () => {
  const visitor = (node, parent) => {
    var _parent$children$inde;
    if ('children' in node) {
      const nodeAsParent = node;
      nodeAsParent.children.forEach(child => {
        visitor(child, nodeAsParent);
      });
    }
    if (node.type !== 'text' && node.type !== 'inlineCode' && node.type !== 'code') {
      return;
    }
    const textNode = node;
    const indexOfCursor = textNode.value.indexOf(CURSOR);
    if (indexOfCursor === -1) {
      return;
    }
    textNode.value = textNode.value.replace(CURSOR, '');
    const indexOfNode = (_parent$children$inde = parent === null || parent === void 0 ? void 0 : parent.children.indexOf(textNode)) !== null && _parent$children$inde !== void 0 ? _parent$children$inde : 0;
    parent === null || parent === void 0 ? void 0 : parent.children.splice(indexOfNode + 1, 0, {
      type: 'cursor',
      value: CURSOR
    });
  };
  return tree => {
    visitor(tree);
  };
};
const getPluginDependencies = () => {
  const parsingPlugins = (0, _eui.getDefaultEuiMarkdownParsingPlugins)();
  const processingPlugins = (0, _eui.getDefaultEuiMarkdownProcessingPlugins)();
  const {
    components
  } = processingPlugins[1][1];
  processingPlugins[1][1].components = {
    ...components,
    cursor: Cursor,
    customCodeBlock: props => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_custom_code_block.CustomCodeBlock, {
        value: props.value
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }));
    },
    table: props => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "euiBasicTable"
    }, ' ', /*#__PURE__*/_react.default.createElement("table", (0, _extends2.default)({
      className: "euiTable"
    }, props))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })),
    th: props => {
      const {
        children,
        ...rest
      } = props;
      return /*#__PURE__*/_react.default.createElement("th", (0, _extends2.default)({
        className: "euiTableHeaderCell"
      }, rest), /*#__PURE__*/_react.default.createElement("span", {
        className: "euiTableCellContent"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "euiTableCellContent__text",
        title: children
      }, children)));
    },
    tr: props => /*#__PURE__*/_react.default.createElement("tr", (0, _extends2.default)({
      className: "euiTableRow"
    }, props)),
    td: props => {
      const {
        children,
        ...rest
      } = props;
      return /*#__PURE__*/_react.default.createElement("td", (0, _extends2.default)({
        className: "euiTableRowCell"
      }, rest), /*#__PURE__*/_react.default.createElement("div", {
        className: "euiTableCellContent euiTableCellContent--truncateText"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "euiTableCellContent__text",
        title: children
      }, children)));
    }
  };
  return {
    parsingPluginList: [loadingCursorPlugin, _custom_codeblock_markdown_plugin.customCodeBlockLanguagePlugin, ...parsingPlugins],
    processingPluginList: processingPlugins
  };
};
function MessageText({
  loading,
  content,
  index
}) {
  const containerClassName = (0, _css.css)`
    overflow-wrap: break-word;
  `;
  const {
    parsingPluginList,
    processingPluginList
  } = getPluginDependencies();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: containerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat
  // used by augmentMessageCodeBlocks
  , {
    className: `message-${index}`,
    "data-test-subj": 'messageText',
    parsingPluginList: parsingPluginList,
    processingPluginList: processingPluginList
  }, `${content}${loading ? CURSOR : ''}`));
}