"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamComment = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_stream = require("./use_stream");
var _stop_generating_button = require("./buttons/stop_generating_button");
var _regenerate_response_button = require("./buttons/regenerate_response_button");
var _message_panel = require("./message_panel");
var _message_text = require("./message_text");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StreamComment = ({
  amendMessage,
  content,
  connectorTypeTitle,
  index,
  isError = false,
  isFetching = false,
  isLastComment,
  reader,
  regenerateMessage,
  transformMessage
}) => {
  const {
    error,
    isLoading,
    isStreaming,
    pendingMessage,
    setComplete
  } = (0, _use_stream.useStream)({
    amendMessage,
    content,
    connectorTypeTitle,
    reader,
    isError
  });
  const currentState = (0, _react.useRef)({
    isStreaming,
    pendingMessage,
    amendMessage
  });
  (0, _react.useEffect)(() => {
    currentState.current = {
      isStreaming,
      pendingMessage,
      amendMessage
    };
  }, [amendMessage, isStreaming, pendingMessage]);
  (0, _react.useEffect)(() => () => {
    // if the component is unmounted while streaming, amend the message with the pending message
    if (currentState.current.isStreaming && currentState.current.pendingMessage.length > 0) {
      var _currentState$current;
      currentState.current.amendMessage((_currentState$current = currentState.current.pendingMessage) !== null && _currentState$current !== void 0 ? _currentState$current : '');
    }
  },
  // store values in currentState to detect true unmount
  []);
  const message = (0, _react.useMemo)(
  // only transform streaming message, transform happens upstream for content message
  () => content !== null && content !== void 0 ? content : transformMessage(pendingMessage).content, [content, transformMessage, pendingMessage]);
  const isAnythingLoading = (0, _react.useMemo)(() => isFetching || isLoading || isStreaming, [isFetching, isLoading, isStreaming]);
  const controls = (0, _react.useMemo)(() => {
    if (reader == null || !isLastComment) {
      return;
    }
    if (isAnythingLoading) {
      return /*#__PURE__*/_react.default.createElement(_stop_generating_button.StopGeneratingButton, {
        onClick: () => {
          setComplete(true);
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      justifyContent: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_regenerate_response_button.RegenerateResponseButton, {
      onClick: regenerateMessage
    })));
  }, [isAnythingLoading, isLastComment, reader, regenerateMessage, setComplete]);
  return /*#__PURE__*/_react.default.createElement(_message_panel.MessagePanel, {
    body: /*#__PURE__*/_react.default.createElement(_message_text.MessageText, {
      content: message,
      index: index,
      loading: isAnythingLoading
    }),
    error: error ? new Error(error) : undefined,
    controls: controls
  });
};
exports.StreamComment = StreamComment;