"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getComments = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _helpers = require("../helpers");
var _stream = require("./stream");
var _comment_actions = require("../comment_actions");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformMessageWithReplacements = ({
  message,
  content,
  showAnonymizedValues,
  replacements
}) => {
  return {
    ...message,
    content: showAnonymizedValues || !replacements ? content : (0, _helpers.getMessageContentWithReplacements)({
      messageContent: content,
      replacements
    })
  };
};
const getComments = ({
  amendMessage,
  currentConversation,
  isFetchingResponse,
  regenerateMessage,
  showAnonymizedValues
}) => {
  var _currentConversation$;
  const amendMessageOfConversation = content => {
    amendMessage({
      conversationId: currentConversation.id,
      content
    });
  };
  const regenerateMessageOfConversation = () => {
    regenerateMessage(currentConversation.id);
  };
  const connectorTypeTitle = (_currentConversation$ = currentConversation.apiConfig.connectorTypeTitle) !== null && _currentConversation$ !== void 0 ? _currentConversation$ : '';
  const extraLoadingComment = isFetchingResponse ? [{
    username: i18n.ASSISTANT,
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    }),
    timestamp: '...',
    children: /*#__PURE__*/_react.default.createElement(_stream.StreamComment, {
      amendMessage: amendMessageOfConversation,
      connectorTypeTitle: connectorTypeTitle,
      content: "",
      regenerateMessage: regenerateMessageOfConversation,
      isLastComment: true,
      transformMessage: () => ({
        content: ''
      }),
      isFetching: true
      // we never need to append to a code block in the loading comment, which is what this index is used for
      ,
      index: 999
    })
  }] : [];
  return [...currentConversation.messages.map((message, index) => {
    var _message$content;
    const isLastComment = index === currentConversation.messages.length - 1;
    const isUser = message.role === 'user';
    const replacements = currentConversation.replacements;
    const messageProps = {
      timelineAvatar: isUser ? /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        name: "user",
        size: "l",
        color: "subdued",
        iconType: "userAvatar"
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        name: "machine",
        size: "l",
        color: "subdued",
        iconType: _elasticAssistant.AssistantAvatar
      }),
      timestamp: i18n.AT(message.timestamp.length === 0 ? new Date().toLocaleString() : message.timestamp),
      username: isUser ? i18n.YOU : i18n.ASSISTANT,
      eventColor: message.isError ? 'danger' : undefined
    };
    const transformMessage = content => transformMessageWithReplacements({
      message,
      content,
      showAnonymizedValues,
      replacements
    });

    // message still needs to stream, no actions returned and replacements handled by streamer
    if (!(message.content && message.content.length)) {
      return {
        ...messageProps,
        children: /*#__PURE__*/_react.default.createElement(_stream.StreamComment, {
          amendMessage: amendMessageOfConversation,
          connectorTypeTitle: connectorTypeTitle,
          index: index,
          isLastComment: isLastComment,
          isError: message.isError,
          reader: message.reader,
          regenerateMessage: regenerateMessageOfConversation,
          transformMessage: transformMessage
        })
      };
    }

    // transform message here so we can send correct message to CommentActions
    const transformedMessage = transformMessage((_message$content = message.content) !== null && _message$content !== void 0 ? _message$content : '');
    return {
      ...messageProps,
      actions: /*#__PURE__*/_react.default.createElement(_comment_actions.CommentActions, {
        message: transformedMessage
      }),
      children: /*#__PURE__*/_react.default.createElement(_stream.StreamComment, {
        amendMessage: amendMessageOfConversation,
        connectorTypeTitle: connectorTypeTitle,
        content: transformedMessage.content,
        index: index,
        isLastComment: isLastComment
        // reader is used to determine if streaming controls are shown
        ,
        reader: transformedMessage.reader,
        regenerateMessage: regenerateMessageOfConversation,
        transformMessage: transformMessage
      })
    };
  }), ...extraLoadingComment];
};
exports.getComments = getComments;