"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _cellActions = require("@kbn/cell-actions");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _upselling_provider = require("../common/components/upselling_provider");
var _user_info = require("../detections/components/user_info");
var _constants = require("../../common/constants");
var _error_toast_dispatcher = require("../common/components/error_toast_dispatcher");
var _ml_capabilities_provider = require("../common/components/ml/permissions/ml_capabilities_provider");
var _toasters = require("../common/components/toasters");
var _kibana = require("../common/lib/kibana");
var _routes = require("./routes");
var _user_privileges_context = require("../common/components/user_privileges/user_privileges_context");
var _query_client_provider = require("../common/containers/query_client/query_client_provider");
var _provider = require("../common/components/discover_in_timeline/provider");
var _provider2 = require("../assistant/provider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StartAppComponent = ({
  children,
  history,
  onAppLeave,
  store,
  theme$
}) => {
  const services = (0, _kibana.useKibana)().services;
  const {
    i18n,
    analytics,
    application: {
      capabilities
    },
    uiActions,
    upselling
  } = services;
  const [darkMode] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_DARK_MODE);
  return /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundaryProvider, {
    analytics: analytics
  }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, null, /*#__PURE__*/_react.default.createElement(i18n.Context, null, /*#__PURE__*/_react.default.createElement(_toasters.ManageGlobalToaster, null, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: darkMode
  }, /*#__PURE__*/_react.default.createElement(_ml_capabilities_provider.MlCapabilitiesProvider, null, /*#__PURE__*/_react.default.createElement(_user_privileges_context.UserPrivilegesProvider, {
    kibanaCapabilities: capabilities
  }, /*#__PURE__*/_react.default.createElement(_user_info.ManageUserInfo, null, /*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
    core: services
  }, /*#__PURE__*/_react.default.createElement(_query_client_provider.ReactQueryClientProvider, null, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: uiActions.getTriggerCompatibleActions
  }, /*#__PURE__*/_react.default.createElement(_upselling_provider.UpsellingProvider, {
    upsellingService: upselling
  }, /*#__PURE__*/_react.default.createElement(_provider.DiscoverInTimelineContextProvider, null, /*#__PURE__*/_react.default.createElement(_provider2.AssistantProvider, null, /*#__PURE__*/_react.default.createElement(_routes.PageRouter, {
    history: history,
    onAppLeave: onAppLeave
  }, children)))))))))))), /*#__PURE__*/_react.default.createElement(_error_toast_dispatcher.ErrorToastDispatcher, null), /*#__PURE__*/_react.default.createElement(_toasters.GlobalToaster, null))))));
};
const StartApp = /*#__PURE__*/(0, _react.memo)(StartAppComponent);
const SecurityAppComponent = ({
  children,
  history,
  onAppLeave,
  services,
  store,
  theme$
}) => {
  var _services$cloud$Cloud, _services$cloud;
  const CloudProvider = (_services$cloud$Cloud = (_services$cloud = services.cloud) === null || _services$cloud === void 0 ? void 0 : _services$cloud.CloudContextProvider) !== null && _services$cloud$Cloud !== void 0 ? _services$cloud$Cloud : _react.default.Fragment;
  return /*#__PURE__*/_react.default.createElement(_kibana.KibanaContextProvider, {
    services: {
      appName: _constants.APP_NAME,
      ...services
    }
  }, /*#__PURE__*/_react.default.createElement(CloudProvider, null, /*#__PURE__*/_react.default.createElement(StartApp, {
    history: history,
    onAppLeave: onAppLeave,
    store: store,
    theme$: theme$
  }, children)));
};
const SecurityApp = /*#__PURE__*/(0, _react.memo)(SecurityAppComponent);
exports.SecurityApp = SecurityApp;