"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatPageFilterSearchParam = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatPageFilterSearchParam = filters => {
  return filters.map(({
    title,
    fieldName,
    selectedOptions = [],
    existsSelected = false,
    exclude = false
  }) => ({
    title: title !== null && title !== void 0 ? title : fieldName,
    selectedOptions,
    fieldName,
    existsSelected,
    exclude
  }));
};
exports.formatPageFilterSearchParam = formatPageFilterSearchParam;