"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseConfigSettings = exports.getDefaultConfigSettings = exports.defaultSettings = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A list of allowed values that can be override in `xpack.securitySolution.offeringSettings`.
 * This object is then used to validate and parse the value entered.
 */
const defaultSettings = Object.freeze({
  sideNavEnabled: true,
  ILMEnabled: true,
  ESQLEnabled: true
});
exports.defaultSettings = defaultSettings;
/**
 * Parses the string value used in `xpack.securitySolution.offeringSettings` kibana configuration,
 *
 * @param offeringSettings
 */
const parseConfigSettings = offeringSettings => {
  const configSettings = {};
  const invalidKeys = [];
  for (const optionKey in offeringSettings) {
    if (defaultSettings[optionKey] == null) {
      invalidKeys.push(optionKey);
    } else {
      configSettings[optionKey] = offeringSettings[optionKey];
    }
  }
  const settings = Object.freeze({
    ...defaultSettings,
    ...configSettings
  });
  return {
    settings,
    invalid: invalidKeys
  };
};
exports.parseConfigSettings = parseConfigSettings;
const getDefaultConfigSettings = () => ({
  ...defaultSettings
});
exports.getDefaultConfigSettings = getDefaultConfigSettings;