"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pinnedEventIds = exports.persistPinnedEventSchema = exports.PinnedEventRuntimeType = exports.BarePinnedEventType = void 0;
var runtimeTypes = _interopRequireWildcard(require("io-ts"));
var _utility_types = require("../../../utility_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/no-empty-interface */

const pinnedEventIds = (0, _utility_types.unionWithNullType)(runtimeTypes.array(runtimeTypes.string));
exports.pinnedEventIds = pinnedEventIds;
const persistPinnedEventSchema = runtimeTypes.intersection([runtimeTypes.type({
  eventId: runtimeTypes.string
}), runtimeTypes.partial({
  pinnedEventId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  timelineId: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
})]);

/*
 *  Note Types
 */
exports.persistPinnedEventSchema = persistPinnedEventSchema;
const BarePinnedEventType = runtimeTypes.intersection([runtimeTypes.type({
  timelineId: runtimeTypes.string,
  eventId: runtimeTypes.string
}), runtimeTypes.partial({
  created: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  createdBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  updated: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  updatedBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
})]);

/**
 * This type represents a pinned event type stored in a saved object that does not include any fields that reference
 * other saved objects.
 */
exports.BarePinnedEventType = BarePinnedEventType;
const PinnedEventRuntimeType = runtimeTypes.intersection([runtimeTypes.type({
  pinnedEventId: runtimeTypes.string,
  version: runtimeTypes.string
}), BarePinnedEventType, runtimeTypes.partial({
  timelineVersion: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
})]);
exports.PinnedEventRuntimeType = PinnedEventRuntimeType;