"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.networkHttpSchema = void 0;
var _zod = require("zod");
var _factory_query_type = require("../model/factory_query_type");
var _request_paginated_options = require("../model/request_paginated_options");
var _sort = require("../model/sort");
var _timerange = require("../model/timerange");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const networkHttpSchema = _request_paginated_options.requestOptionsPaginatedSchema.extend({
  ip: _zod.z.string().ip().optional(),
  defaultIndex: _zod.z.array(_zod.z.string()).min(1).optional(),
  timerange: _timerange.timerange,
  sort: _sort.sort,
  factoryQueryType: _zod.z.literal(_factory_query_type.NetworkQueries.http)
});
exports.networkHttpSchema = networkHttpSchema;