"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointSuggestionsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointSuggestionsSchema = {
  body: _configSchema.schema.object({
    field: _configSchema.schema.string(),
    query: _configSchema.schema.string(),
    filters: _configSchema.schema.maybe(_configSchema.schema.any()),
    fieldMeta: _configSchema.schema.maybe(_configSchema.schema.any())
  }),
  params: _configSchema.schema.object({
    // Ready to be used with other suggestion types like endpoints
    suggestion_type: _configSchema.schema.oneOf([_configSchema.schema.literal('eventFilters')])
  })
};
exports.EndpointSuggestionsSchema = EndpointSuggestionsSchema;