"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithOutputs = exports.UserIds = exports.Types = exports.TypeEnum = exports.Type = exports.Timeout = exports.SuccessResponse = exports.Statuses = exports.StatusEnum = exports.Status = exports.StartDate = exports.ProcessActionSchemas = exports.Parameters = exports.PageSize = exports.Page = exports.IdOrUndefined = exports.Id = exports.EndpointIds = exports.EndDate = exports.Comment = exports.Commands = exports.CommandEnum = exports.Command = exports.CaseIds = exports.BaseActionSchema = exports.AlertIds = exports.AgentIds = exports.AgentId = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

const Id = _zod.z.string();
exports.Id = Id;
const IdOrUndefined = Id.nullable();

/**
 * Page number
 */
exports.IdOrUndefined = IdOrUndefined;
const Page = _zod.z.number().int().min(1).default(1);

/**
 * Number of items per page
 */
exports.Page = Page;
const PageSize = _zod.z.number().int().min(1).max(100).default(10);

/**
 * Start date
 */
exports.PageSize = PageSize;
const StartDate = _zod.z.string();

/**
 * End date
 */
exports.StartDate = StartDate;
const EndDate = _zod.z.string();

/**
 * Agent ID
 */
exports.EndDate = EndDate;
const AgentId = _zod.z.string();
exports.AgentId = AgentId;
const AgentIds = _zod.z.union([_zod.z.array(_zod.z.string().min(1)).min(1).max(50), _zod.z.string().min(1)]);

/**
 * The command to be executed (cannot be an empty string)
 */
exports.AgentIds = AgentIds;
const Command = _zod.z.enum(['isolate', 'unisolate', 'kill-process', 'suspend-process', 'running-processes', 'get-file', 'execute', 'upload']);
exports.Command = Command;
const CommandEnum = Command.enum;
exports.CommandEnum = CommandEnum;
const Commands = _zod.z.array(Command);

/**
 * The maximum timeout value in milliseconds (optional)
 */
exports.Commands = Commands;
const Timeout = _zod.z.number().int().min(1);
exports.Timeout = Timeout;
const Status = _zod.z.enum(['failed', 'pending', 'successful']);
exports.Status = Status;
const StatusEnum = Status.enum;
exports.StatusEnum = StatusEnum;
const Statuses = _zod.z.array(Status);

/**
 * User IDs
 */
exports.Statuses = Statuses;
const UserIds = _zod.z.union([_zod.z.array(_zod.z.string().min(1)).min(1), _zod.z.string().min(1)]);

/**
 * With Outputs
 */
exports.UserIds = UserIds;
const WithOutputs = _zod.z.union([_zod.z.array(_zod.z.string().min(1)).min(1), _zod.z.string().min(1)]);
exports.WithOutputs = WithOutputs;
const Type = _zod.z.enum(['automated', 'manual']);
exports.Type = Type;
const TypeEnum = Type.enum;
exports.TypeEnum = TypeEnum;
const Types = _zod.z.array(Type);

/**
 * List of endpoint IDs (cannot contain empty strings)
 */
exports.Types = Types;
const EndpointIds = _zod.z.array(_zod.z.string().min(1)).min(1);

/**
 * If defined, any case associated with the given IDs will be updated (cannot contain empty strings)
 */
exports.EndpointIds = EndpointIds;
const AlertIds = _zod.z.array(_zod.z.string().min(1)).min(1);

/**
 * Case IDs to be updated (cannot contain empty strings)
 */
exports.AlertIds = AlertIds;
const CaseIds = _zod.z.array(_zod.z.string().min(1)).min(1);

/**
 * Optional comment
 */
exports.CaseIds = CaseIds;
const Comment = _zod.z.string();

/**
 * Optional parameters object
 */
exports.Comment = Comment;
const Parameters = _zod.z.object({});
exports.Parameters = Parameters;
const BaseActionSchema = _zod.z.object({
  endpoint_ids: EndpointIds.optional(),
  alert_ids: AlertIds.optional(),
  case_ids: CaseIds.optional(),
  comment: Comment.optional(),
  parameters: Parameters.optional()
});
exports.BaseActionSchema = BaseActionSchema;
const ProcessActionSchemas = BaseActionSchema.merge(_zod.z.object({
  parameters: _zod.z.union([_zod.z.object({
    pid: _zod.z.number().int().min(1).optional()
  }), _zod.z.object({
    entity_id: _zod.z.string().min(1).optional()
  })])
}));
exports.ProcessActionSchemas = ProcessActionSchemas;
const SuccessResponse = _zod.z.object({});
exports.SuccessResponse = SuccessResponse;