"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointActionListRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../endpoint/service/response_actions/constants");
var _constants2 = require("../../../endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: fix the odd TS error

const commandsSchema = _configSchema.schema.oneOf(
// @ts-expect-error TS2769: No overload matches this call
_constants.RESPONSE_ACTION_API_COMMANDS_NAMES.map(command => _configSchema.schema.literal(command)));

// TODO: fix the odd TS error
// @ts-expect-error TS2769: No overload matches this call
const statusesSchema = _configSchema.schema.oneOf(_constants.RESPONSE_ACTION_STATUS.map(status => _configSchema.schema.literal(status)));
// @ts-expect-error TS2769: No overload matches this call
const typesSchema = _configSchema.schema.oneOf(_constants.RESPONSE_ACTION_TYPE.map(type => _configSchema.schema.literal(type)));
const EndpointActionListRequestSchema = {
  query: _configSchema.schema.object({
    agentIds: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }), {
      minSize: 1
    }), _configSchema.schema.string({
      minLength: 1
    })])),
    commands: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(commandsSchema, {
      minSize: 1
    }), commandsSchema])),
    page: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 1,
      min: 1
    })),
    pageSize: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: _constants2.ENDPOINT_DEFAULT_PAGE_SIZE,
      min: 1,
      max: 10000
    })),
    startDate: _configSchema.schema.maybe(_configSchema.schema.string()),
    // date ISO strings or moment date
    endDate: _configSchema.schema.maybe(_configSchema.schema.string()),
    // date ISO strings or moment date
    statuses: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(statusesSchema, {
      minSize: 1,
      maxSize: 3
    }), statusesSchema])),
    userIds: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }), {
      minSize: 1
    }), _configSchema.schema.string({
      minLength: 1
    })])),
    withOutputs: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }), {
      minSize: 1,
      validate: actionIds => {
        if (actionIds.map(v => v.trim()).some(v => !v.length)) {
          return 'actionIds cannot contain empty strings';
        }
      }
    }), _configSchema.schema.string({
      minLength: 1,
      validate: actionId => {
        if (!actionId.trim().length) {
          return 'actionId cannot be an empty string';
        }
      }
    })])),
    types: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(typesSchema, {
      minSize: 1,
      maxSize: 2
    }), typesSchema]))
  })
};
exports.EndpointActionListRequestSchema = EndpointActionListRequestSchema;