"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointActionLogRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointActionLogRequestSchema = {
  query: _configSchema.schema.object({
    page: _configSchema.schema.number({
      defaultValue: 1,
      min: 1
    }),
    page_size: _configSchema.schema.number({
      defaultValue: 10,
      min: 1,
      max: 100
    }),
    start_date: _configSchema.schema.string(),
    end_date: _configSchema.schema.string()
  }),
  params: _configSchema.schema.object({
    agent_id: _configSchema.schema.string()
  })
};
exports.EndpointActionLogRequestSchema = EndpointActionLogRequestSchema;