"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportRulesResponse = exports.ImportRulesRequestQuery = void 0;
var _zod = require("zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _error_schema = require("../../model/error_schema.gen");
var _warning_schema = require("../../model/warning_schema.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

const ImportRulesRequestQuery = _zod.z.object({
  /**
   * Determines whether existing rules with the same `rule_id` are overwritten.
   */
  overwrite: _zodHelpers.BooleanFromString.optional().default(false),
  /**
   * Determines whether existing exception lists with the same `list_id` are overwritten.
   */
  overwrite_exceptions: _zodHelpers.BooleanFromString.optional().default(false),
  /**
   * Determines whether existing actions with the same `kibana.alert.rule.actions.id` are overwritten.
   */
  overwrite_action_connectors: _zodHelpers.BooleanFromString.optional().default(false),
  /**
   * Generates a new list ID for each imported exception list.
   */
  as_new_list: _zodHelpers.BooleanFromString.optional().default(false)
});
exports.ImportRulesRequestQuery = ImportRulesRequestQuery;
const ImportRulesResponse = _zod.z.object({
  exceptions_success: _zod.z.boolean(),
  exceptions_success_count: _zod.z.number().int().min(0),
  exceptions_errors: _zod.z.array(_error_schema.ErrorSchema),
  rules_count: _zod.z.number().int().min(0),
  success: _zod.z.boolean(),
  success_count: _zod.z.number().int().min(0),
  errors: _zod.z.array(_error_schema.ErrorSchema),
  action_connectors_errors: _zod.z.array(_error_schema.ErrorSchema),
  action_connectors_warnings: _zod.z.array(_warning_schema.WarningSchema),
  action_connectors_success: _zod.z.boolean(),
  action_connectors_success_count: _zod.z.number().int().min(0)
}).strict();
exports.ImportRulesResponse = ImportRulesResponse;