"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThrottleForBulkActionsEnum = exports.ThrottleForBulkActions = exports.RuleDetailsInError = exports.PerformBulkActionResponse = exports.PerformBulkActionRequestQuery = exports.PerformBulkActionRequestBody = exports.NormalizedRuleError = exports.NormalizedRuleAction = exports.BulkExportRules = exports.BulkExportActionResponse = exports.BulkEnableRules = exports.BulkEditSkipReason = exports.BulkEditRules = exports.BulkEditActionSummary = exports.BulkEditActionResults = exports.BulkEditActionResponse = exports.BulkDuplicateRules = exports.BulkDisableRules = exports.BulkDeleteRules = exports.BulkActionsDryRunErrCodeEnum = exports.BulkActionsDryRunErrCode = exports.BulkActionTypeEnum = exports.BulkActionType = exports.BulkActionSkipResult = exports.BulkActionEditTypeEnum = exports.BulkActionEditType = exports.BulkActionEditPayloadTimeline = exports.BulkActionEditPayloadTags = exports.BulkActionEditPayloadSchedule = exports.BulkActionEditPayloadRuleActions = exports.BulkActionEditPayloadIndexPatterns = exports.BulkActionEditPayload = exports.BulkActionBase = void 0;
var _zod = require("zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _rule_schemas = require("../../model/rule_schema/rule_schemas.gen");
var _common_attributes = require("../../model/rule_schema/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

const BulkEditSkipReason = _zod.z.literal('RULE_NOT_MODIFIED');
exports.BulkEditSkipReason = BulkEditSkipReason;
const BulkActionSkipResult = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional(),
  skip_reason: BulkEditSkipReason
});
exports.BulkActionSkipResult = BulkActionSkipResult;
const RuleDetailsInError = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional()
});
exports.RuleDetailsInError = RuleDetailsInError;
const BulkActionsDryRunErrCode = _zod.z.enum(['IMMUTABLE', 'MACHINE_LEARNING_AUTH', 'MACHINE_LEARNING_INDEX_PATTERN', 'ESQL_INDEX_PATTERN']);
exports.BulkActionsDryRunErrCode = BulkActionsDryRunErrCode;
const BulkActionsDryRunErrCodeEnum = BulkActionsDryRunErrCode.enum;
exports.BulkActionsDryRunErrCodeEnum = BulkActionsDryRunErrCodeEnum;
const NormalizedRuleError = _zod.z.object({
  message: _zod.z.string(),
  status_code: _zod.z.number().int(),
  err_code: BulkActionsDryRunErrCode.optional(),
  rules: _zod.z.array(RuleDetailsInError)
});
exports.NormalizedRuleError = NormalizedRuleError;
const BulkEditActionResults = _zod.z.object({
  updated: _zod.z.array(_rule_schemas.RuleResponse),
  created: _zod.z.array(_rule_schemas.RuleResponse),
  deleted: _zod.z.array(_rule_schemas.RuleResponse),
  skipped: _zod.z.array(BulkActionSkipResult)
});
exports.BulkEditActionResults = BulkEditActionResults;
const BulkEditActionSummary = _zod.z.object({
  failed: _zod.z.number().int(),
  skipped: _zod.z.number().int(),
  succeeded: _zod.z.number().int(),
  total: _zod.z.number().int()
});
exports.BulkEditActionSummary = BulkEditActionSummary;
const BulkEditActionResponse = _zod.z.object({
  success: _zod.z.boolean().optional(),
  status_code: _zod.z.number().int().optional(),
  message: _zod.z.string().optional(),
  rules_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: BulkEditActionResults,
    summary: BulkEditActionSummary,
    errors: _zod.z.array(NormalizedRuleError).optional()
  })
});
exports.BulkEditActionResponse = BulkEditActionResponse;
const BulkExportActionResponse = _zod.z.string();
exports.BulkExportActionResponse = BulkExportActionResponse;
const BulkActionBase = _zod.z.object({
  /**
   * Query to filter rules
   */
  query: _zod.z.string().optional(),
  /**
   * Array of rule IDs
   */
  ids: _zod.z.array(_zod.z.string()).min(1).optional()
});
exports.BulkActionBase = BulkActionBase;
const BulkDeleteRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('delete')
}));
exports.BulkDeleteRules = BulkDeleteRules;
const BulkDisableRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('disable')
}));
exports.BulkDisableRules = BulkDisableRules;
const BulkEnableRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('enable')
}));
exports.BulkEnableRules = BulkEnableRules;
const BulkExportRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('export')
}));
exports.BulkExportRules = BulkExportRules;
const BulkDuplicateRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('duplicate'),
  duplicate: _zod.z.object({
    /**
     * Whether to copy exceptions from the original rule
     */
    include_exceptions: _zod.z.boolean(),
    /**
     * Whether to copy expired exceptions from the original rule
     */
    include_expired_exceptions: _zod.z.boolean()
  }).optional()
}));

/**
 * The condition for throttling the notification: 'rule', 'no_actions', or time duration
 */
exports.BulkDuplicateRules = BulkDuplicateRules;
const ThrottleForBulkActions = _zod.z.enum(['rule', '1h', '1d', '7d']);
exports.ThrottleForBulkActions = ThrottleForBulkActions;
const ThrottleForBulkActionsEnum = ThrottleForBulkActions.enum;
exports.ThrottleForBulkActionsEnum = ThrottleForBulkActionsEnum;
const BulkActionType = _zod.z.enum(['enable', 'disable', 'export', 'delete', 'duplicate', 'edit']);
exports.BulkActionType = BulkActionType;
const BulkActionTypeEnum = BulkActionType.enum;
exports.BulkActionTypeEnum = BulkActionTypeEnum;
const BulkActionEditType = _zod.z.enum(['add_tags', 'delete_tags', 'set_tags', 'add_index_patterns', 'delete_index_patterns', 'set_index_patterns', 'set_timeline', 'add_rule_actions', 'set_rule_actions', 'set_schedule']);
exports.BulkActionEditType = BulkActionEditType;
const BulkActionEditTypeEnum = BulkActionEditType.enum;
exports.BulkActionEditTypeEnum = BulkActionEditTypeEnum;
const NormalizedRuleAction = _zod.z.object({
  group: _common_attributes.RuleActionGroup,
  id: _common_attributes.RuleActionId,
  params: _common_attributes.RuleActionParams,
  frequency: _common_attributes.RuleActionFrequency.optional(),
  alerts_filter: _common_attributes.RuleActionAlertsFilter.optional()
}).strict();
exports.NormalizedRuleAction = NormalizedRuleAction;
const BulkActionEditPayloadRuleActions = _zod.z.object({
  type: _zod.z.enum(['add_rule_actions', 'set_rule_actions']),
  value: _zod.z.object({
    throttle: ThrottleForBulkActions.optional(),
    actions: _zod.z.array(NormalizedRuleAction)
  })
});
exports.BulkActionEditPayloadRuleActions = BulkActionEditPayloadRuleActions;
const BulkActionEditPayloadSchedule = _zod.z.object({
  type: _zod.z.literal('set_schedule'),
  value: _zod.z.object({
    /**
     * Interval in which the rule is executed
     */
    interval: _zod.z.string().regex(/^[1-9]\d*[smh]$/),
    /**
     * Lookback time for the rule
     */
    lookback: _zod.z.string().regex(/^[1-9]\d*[smh]$/)
  })
});
exports.BulkActionEditPayloadSchedule = BulkActionEditPayloadSchedule;
const BulkActionEditPayloadIndexPatterns = _zod.z.object({
  type: _zod.z.enum(['add_index_patterns', 'delete_index_patterns', 'set_index_patterns']),
  value: _common_attributes.IndexPatternArray,
  overwrite_data_views: _zod.z.boolean().optional()
});
exports.BulkActionEditPayloadIndexPatterns = BulkActionEditPayloadIndexPatterns;
const BulkActionEditPayloadTags = _zod.z.object({
  type: _zod.z.enum(['add_tags', 'delete_tags', 'set_tags']),
  value: _common_attributes.RuleTagArray
});
exports.BulkActionEditPayloadTags = BulkActionEditPayloadTags;
const BulkActionEditPayloadTimeline = _zod.z.object({
  type: _zod.z.literal('set_timeline'),
  value: _zod.z.object({
    timeline_id: _common_attributes.TimelineTemplateId,
    timeline_title: _common_attributes.TimelineTemplateTitle
  })
});
exports.BulkActionEditPayloadTimeline = BulkActionEditPayloadTimeline;
const BulkActionEditPayload = _zod.z.union([BulkActionEditPayloadTags, BulkActionEditPayloadIndexPatterns, BulkActionEditPayloadTimeline, BulkActionEditPayloadRuleActions, BulkActionEditPayloadSchedule]);
exports.BulkActionEditPayload = BulkActionEditPayload;
const BulkEditRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('edit'),
  /**
   * Array of objects containing the edit operations
   */
  edit: _zod.z.array(BulkActionEditPayload).min(1)
}));
exports.BulkEditRules = BulkEditRules;
const PerformBulkActionRequestQuery = _zod.z.object({
  /**
   * Enables dry run mode for the request call.
   */
  dry_run: _zodHelpers.BooleanFromString.optional()
});
exports.PerformBulkActionRequestQuery = PerformBulkActionRequestQuery;
const PerformBulkActionRequestBody = _zod.z.union([BulkDeleteRules, BulkDisableRules, BulkEnableRules, BulkExportRules, BulkDuplicateRules, BulkEditRules]);
exports.PerformBulkActionRequestBody = PerformBulkActionRequestBody;
const PerformBulkActionResponse = _zod.z.union([BulkEditActionResponse, BulkExportActionResponse]);
exports.PerformBulkActionResponse = PerformBulkActionResponse;