"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampOverrideObject = exports.TimelineTemplateReference = exports.SavedKqlQuery = exports.RuleSchedule = exports.RuleNameOverrideObject = exports.RuleKqlQuery = exports.RuleEsqlQuery = exports.RuleEqlQuery = exports.RuleDataSource = exports.KqlQueryType = exports.InlineKqlQuery = exports.DataSourceType = exports.DataSourceIndexPatterns = exports.DataSourceDataView = exports.BuildingBlockObject = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _rule_schema_legacy = require("../../../../model/rule_schema_legacy");
var _schemas = require("../../../../model/schemas");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO https://github.com/elastic/security-team/issues/7491
// eslint-disable-next-line no-restricted-imports
// -------------------------------------------------------------------------------------------------
// Rule data source
let DataSourceType;
exports.DataSourceType = DataSourceType;
(function (DataSourceType) {
  DataSourceType["index_patterns"] = "index_patterns";
  DataSourceType["data_view"] = "data_view";
})(DataSourceType || (exports.DataSourceType = DataSourceType = {}));
const DataSourceIndexPatterns = t.exact(t.type({
  type: t.literal(DataSourceType.index_patterns),
  index_patterns: _rule_schema_legacy.IndexPatternArray
}));
exports.DataSourceIndexPatterns = DataSourceIndexPatterns;
const DataSourceDataView = t.exact(t.type({
  type: t.literal(DataSourceType.data_view),
  data_view_id: _rule_schema_legacy.DataViewId
}));
exports.DataSourceDataView = DataSourceDataView;
const RuleDataSource = t.union([DataSourceIndexPatterns, DataSourceDataView]);

// -------------------------------------------------------------------------------------------------
// Rule data query
exports.RuleDataSource = RuleDataSource;
let KqlQueryType;
exports.KqlQueryType = KqlQueryType;
(function (KqlQueryType) {
  KqlQueryType["inline_query"] = "inline_query";
  KqlQueryType["saved_query"] = "saved_query";
})(KqlQueryType || (exports.KqlQueryType = KqlQueryType = {}));
const InlineKqlQuery = t.exact(t.type({
  type: t.literal(KqlQueryType.inline_query),
  query: _rule_schema_legacy.RuleQuery,
  language: _rule_schema_legacy.KqlQueryLanguage,
  filters: _rule_schema_legacy.RuleFilterArray
}));
exports.InlineKqlQuery = InlineKqlQuery;
const SavedKqlQuery = t.exact(t.type({
  type: t.literal(KqlQueryType.saved_query),
  saved_query_id: _schemas.saved_id
}));
exports.SavedKqlQuery = SavedKqlQuery;
const RuleKqlQuery = t.union([InlineKqlQuery, SavedKqlQuery]);
exports.RuleKqlQuery = RuleKqlQuery;
const RuleEqlQuery = t.exact(t.type({
  query: _rule_schema_legacy.RuleQuery,
  language: t.literal('eql'),
  filters: _rule_schema_legacy.RuleFilterArray
}));
exports.RuleEqlQuery = RuleEqlQuery;
const RuleEsqlQuery = t.exact(t.type({
  query: _rule_schema_legacy.RuleQuery,
  language: t.literal('esql')
}));

// -------------------------------------------------------------------------------------------------
// Rule schedule
exports.RuleEsqlQuery = RuleEsqlQuery;
const RuleSchedule = t.exact(t.type({
  interval: (0, _securitysolutionIoTsTypes.TimeDuration)({
    allowedUnits: ['s', 'm', 'h']
  }),
  lookback: (0, _securitysolutionIoTsTypes.TimeDuration)({
    allowedUnits: ['s', 'm', 'h']
  })
}));

// -------------------------------------------------------------------------------------------------
// Rule name override
exports.RuleSchedule = RuleSchedule;
const RuleNameOverrideObject = t.exact(t.type({
  field_name: _rule_schema_legacy.RuleNameOverride
}));

// -------------------------------------------------------------------------------------------------
// Timestamp override
exports.RuleNameOverrideObject = RuleNameOverrideObject;
const TimestampOverrideObject = t.exact(t.type({
  field_name: _rule_schema_legacy.TimestampOverride,
  fallback_disabled: _rule_schema_legacy.TimestampOverrideFallbackDisabled
}));

// -------------------------------------------------------------------------------------------------
// Reference to a timeline template
exports.TimestampOverrideObject = TimestampOverrideObject;
const TimelineTemplateReference = t.exact(t.type({
  timeline_id: _rule_schema_legacy.TimelineTemplateId,
  timeline_title: _rule_schema_legacy.TimelineTemplateTitle
}));

// -------------------------------------------------------------------------------------------------
// Building block
exports.TimelineTemplateReference = TimelineTemplateReference;
const BuildingBlockObject = t.exact(t.type({
  type: _rule_schema_legacy.BuildingBlockType
}));
exports.BuildingBlockObject = BuildingBlockObject;