"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleResponseOsqueryAction = exports.RuleResponseEndpointAction = exports.ResponseActionRuleParamsOrUndefined = exports.ResponseActionArray = exports.ResponseAction = exports.OsqueryParamsCamelCase = exports.OsqueryParams = exports.EndpointParams = void 0;
var _osqueryIoTsTypes = require("@kbn/osquery-io-ts-types");
var t = _interopRequireWildcard(require("io-ts"));
var _constants = require("../../../../endpoint/service/response_actions/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// to enable using RESPONSE_ACTION_API_COMMANDS_NAMES as a type
function keyObject(arr) {
  return Object.fromEntries(arr.map(v => [v, null]));
}
const EndpointParams = t.type({
  command: t.keyof(keyObject(_constants.ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS)),
  comment: t.union([t.string, t.undefined])
});
exports.EndpointParams = EndpointParams;
const OsqueryParams = t.type({
  query: t.union([t.string, t.undefined]),
  ecs_mapping: t.union([_osqueryIoTsTypes.ecsMapping, t.undefined]),
  queries: t.union([_osqueryIoTsTypes.arrayQueries, t.undefined]),
  pack_id: t.union([t.string, t.undefined]),
  saved_query_id: t.union([t.string, t.undefined])
});
exports.OsqueryParams = OsqueryParams;
const OsqueryParamsCamelCase = t.type({
  query: t.union([t.string, t.undefined]),
  ecsMapping: t.union([_osqueryIoTsTypes.ecsMapping, t.undefined]),
  queries: t.union([_osqueryIoTsTypes.arrayQueries, t.undefined]),
  packId: t.union([t.string, t.undefined]),
  savedQueryId: t.union([t.string, t.undefined])
});

// When we create new response action types, create a union of types
exports.OsqueryParamsCamelCase = OsqueryParamsCamelCase;
const RuleResponseOsqueryAction = t.strict({
  actionTypeId: t.literal('.osquery'),
  params: OsqueryParamsCamelCase
});
exports.RuleResponseOsqueryAction = RuleResponseOsqueryAction;
const RuleResponseEndpointAction = t.strict({
  actionTypeId: t.literal('.endpoint'),
  params: EndpointParams
});
exports.RuleResponseEndpointAction = RuleResponseEndpointAction;
const ResponseActionRuleParam = t.union([RuleResponseOsqueryAction, RuleResponseEndpointAction]);
const ResponseActionRuleParamsOrUndefined = t.union([t.array(ResponseActionRuleParam), t.undefined]);

// When we create new response action types, create a union of types
exports.ResponseActionRuleParamsOrUndefined = ResponseActionRuleParamsOrUndefined;
const OsqueryResponseAction = t.strict({
  action_type_id: t.literal('.osquery'),
  params: OsqueryParams
});
const EndpointResponseAction = t.strict({
  action_type_id: t.literal('.endpoint'),
  params: EndpointParams
});
const ResponseAction = t.union([OsqueryResponseAction, EndpointResponseAction]);
exports.ResponseAction = ResponseAction;
const ResponseActionArray = t.array(ResponseAction);
exports.ResponseActionArray = ResponseActionArray;