"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatQuery = exports.ThreatMapping = exports.ThreatIndicatorPath = exports.ThreatIndex = exports.ThreatFilters = exports.ItemsPerSearch = exports.ConcurrentSearches = void 0;
var _zod = require("zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

/**
 * Query to execute
 */

const ThreatQuery = _zod.z.string();
exports.ThreatQuery = ThreatQuery;
const ThreatMapping = _zod.z.array(_zod.z.object({
  entries: _zod.z.array(_zod.z.object({
    field: _common_attributes.NonEmptyString,
    type: _zod.z.literal('mapping'),
    value: _common_attributes.NonEmptyString
  }))
})).min(1);
exports.ThreatMapping = ThreatMapping;
const ThreatIndex = _zod.z.array(_zod.z.string());
exports.ThreatIndex = ThreatIndex;
const ThreatFilters = _zod.z.array(_zod.z.unknown());

/**
 * Defines the path to the threat indicator in the indicator documents (optional)
 */
exports.ThreatFilters = ThreatFilters;
const ThreatIndicatorPath = _zod.z.string();
exports.ThreatIndicatorPath = ThreatIndicatorPath;
const ConcurrentSearches = _zod.z.number().int().min(1);
exports.ConcurrentSearches = ConcurrentSearches;
const ItemsPerSearch = _zod.z.number().int().min(1);
exports.ItemsPerSearch = ItemsPerSearch;