"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityBaseKibanaFeature = void 0;
var _i18n = require("@kbn/i18n");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_RULE_TYPES = [_constants.LEGACY_NOTIFICATIONS_ID, _securitysolutionRules.ESQL_RULE_TYPE_ID, _securitysolutionRules.EQL_RULE_TYPE_ID, _securitysolutionRules.INDICATOR_RULE_TYPE_ID, _securitysolutionRules.ML_RULE_TYPE_ID, _securitysolutionRules.QUERY_RULE_TYPE_ID, _securitysolutionRules.SAVED_QUERY_RULE_TYPE_ID, _securitysolutionRules.THRESHOLD_RULE_TYPE_ID, _securitysolutionRules.NEW_TERMS_RULE_TYPE_ID];
const getSecurityBaseKibanaFeature = ({
  savedObjects
}) => ({
  id: _constants.SERVER_APP_ID,
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionTitle', {
    defaultMessage: 'Security'
  }),
  order: 1100,
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security,
  app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, _constants.CLOUD_DEFEND_APP_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: SECURITY_RULE_TYPES,
  privileges: {
    all: {
      app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, _constants.CLOUD_DEFEND_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'lists-all', 'lists-read', 'lists-summary', 'rac', 'cloud-security-posture-all', 'cloud-security-posture-read', 'cloud-defend-all', 'cloud-defend-read'],
      savedObject: {
        all: ['alert', ...savedObjects],
        read: []
      },
      alerting: {
        rule: {
          all: SECURITY_RULE_TYPES
        },
        alert: {
          all: SECURITY_RULE_TYPES
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show', 'crud']
    },
    read: {
      app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, _constants.CLOUD_DEFEND_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'lists-read', 'rac', 'cloud-security-posture-read', 'cloud-defend-read'],
      savedObject: {
        all: [],
        read: [...savedObjects]
      },
      alerting: {
        rule: {
          read: SECURITY_RULE_TYPES
        },
        alert: {
          all: SECURITY_RULE_TYPES
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show']
    }
  }
});
exports.getSecurityBaseKibanaFeature = getSecurityBaseKibanaFeature;