"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securityDefaultAppFeaturesConfig = void 0;
var _app_features_keys = require("../app_features_keys");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * App features privileges configuration for the Security Solution Kibana Feature app.
 * These are the configs that are shared between both offering types (ess and serverless).
 * They can be extended on each offering plugin to register privileges using different way on each offering type.
 *
 * Privileges can be added in different ways:
 * - `privileges`: the privileges that will be added directly into the main Security feature.
 * - `subFeatureIds`: the ids of the sub-features that will be added into the Security subFeatures entry.
 * - `subFeaturesPrivileges`: the privileges that will be added into the existing Security subFeature with the privilege `id` specified.
 */
const securityDefaultAppFeaturesConfig = {
  [_app_features_keys.AppFeatureSecurityKey.advancedInsights]: {
    privileges: {
      all: {
        ui: ['entity-analytics'],
        api: [`${_constants.APP_ID}-entity-analytics`]
      },
      read: {
        ui: ['entity-analytics'],
        api: [`${_constants.APP_ID}-entity-analytics`]
      }
    }
  },
  [_app_features_keys.AppFeatureSecurityKey.investigationGuide]: {
    privileges: {
      all: {
        ui: ['investigation-guide']
      },
      read: {
        ui: ['investigation-guide']
      }
    }
  },
  [_app_features_keys.AppFeatureSecurityKey.threatIntelligence]: {
    privileges: {
      all: {
        ui: ['threat-intelligence'],
        api: [`${_constants.APP_ID}-threat-intelligence`]
      },
      read: {
        ui: ['threat-intelligence'],
        api: [`${_constants.APP_ID}-threat-intelligence`]
      }
    }
  },
  [_app_features_keys.AppFeatureSecurityKey.endpointHostManagement]: {
    subFeatureIds: [_app_features_keys.SecuritySubFeatureId.endpointList]
  },
  [_app_features_keys.AppFeatureSecurityKey.endpointPolicyManagement]: {
    subFeatureIds: [_app_features_keys.SecuritySubFeatureId.policyManagement]
  },
  // Adds no additional kibana feature controls
  [_app_features_keys.AppFeatureSecurityKey.endpointPolicyProtections]: {},
  [_app_features_keys.AppFeatureSecurityKey.endpointArtifactManagement]: {
    subFeatureIds: [_app_features_keys.SecuritySubFeatureId.trustedApplications, _app_features_keys.SecuritySubFeatureId.blocklist, _app_features_keys.SecuritySubFeatureId.eventFilters],
    subFeaturesPrivileges: [{
      id: 'host_isolation_exceptions_all',
      api: [`${_constants.APP_ID}-accessHostIsolationExceptions`, `${_constants.APP_ID}-writeHostIsolationExceptions`],
      ui: ['accessHostIsolationExceptions', 'writeHostIsolationExceptions']
    }, {
      id: 'host_isolation_exceptions_read',
      api: [`${_constants.APP_ID}-accessHostIsolationExceptions`],
      ui: ['accessHostIsolationExceptions']
    }]
  },
  [_app_features_keys.AppFeatureSecurityKey.endpointResponseActions]: {
    subFeatureIds: [_app_features_keys.SecuritySubFeatureId.hostIsolationExceptions, _app_features_keys.SecuritySubFeatureId.responseActionsHistory, _app_features_keys.SecuritySubFeatureId.hostIsolation, _app_features_keys.SecuritySubFeatureId.processOperations, _app_features_keys.SecuritySubFeatureId.fileOperations, _app_features_keys.SecuritySubFeatureId.executeAction],
    subFeaturesPrivileges: [{
      id: 'host_isolation_all',
      api: [`${_constants.APP_ID}-writeHostIsolation`],
      ui: ['writeHostIsolation']
    }]
  },
  [_app_features_keys.AppFeatureSecurityKey.osqueryAutomatedResponseActions]: {},
  [_app_features_keys.AppFeatureSecurityKey.externalRuleActions]: {}
};
exports.securityDefaultAppFeaturesConfig = securityDefaultAppFeaturesConfig;