"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssistantBaseKibanaSubFeatureIds = exports.assistantSubFeaturesMap = exports.AssistantSubFeatureId = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This is a sample sub-feature that can be used for future implementations
// @ts-expect-error unused variable
const createConversationSubFeature = {
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.assistant.createConversationSubFeatureName', {
    defaultMessage: 'Create Conversations'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.assistant.description', {
    defaultMessage: 'Create custom conversations.'
  }),
  privilegeGroups: [{
    groupType: 'independent',
    privileges: [{
      api: [],
      id: 'create_conversation',
      name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.assistant.createConversationSubFeatureDetails', {
        defaultMessage: 'Create conversations'
      }),
      includeIn: 'all',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['createConversation']
    }]
  }]
};
let AssistantSubFeatureId;
/**
 * Sub-features that will always be available for Security Assistant
 * regardless of the product type.
 */
exports.AssistantSubFeatureId = AssistantSubFeatureId;
(function (AssistantSubFeatureId) {
  AssistantSubFeatureId["createConversation"] = "createConversationSubFeature";
})(AssistantSubFeatureId || (exports.AssistantSubFeatureId = AssistantSubFeatureId = {}));
const getAssistantBaseKibanaSubFeatureIds = () => [
  // This is a sample sub-feature that can be used for future implementations
  // AssistantSubFeatureId.createConversation,
];

/**
 * Defines all the Security Assistant subFeatures available.
 * The order of the subFeatures is the order they will be displayed
 */
exports.getAssistantBaseKibanaSubFeatureIds = getAssistantBaseKibanaSubFeatureIds;
const assistantSubFeaturesMap = Object.freeze(new Map([
  // This is a sample sub-feature that can be used for future implementations
  // [AssistantSubFeatureId.createConversation, createConversationSubFeature],
]));
exports.assistantSubFeaturesMap = assistantSubFeaturesMap;