"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upsellingSections = exports.upsellingPages = exports.upsellingMessages = exports.registerUpsellings = void 0;
var _common = require("@kbn/security-solution-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _messages = require("@kbn/security-solution-upselling/messages");
var _services = require("../common/services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const EntityAnalyticsUpsellingLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/security-solution-upselling/pages/entity_analytics'))));
const registerUpsellings = (upselling, license, services) => {
  const upsellingPagesToRegister = upsellingPages(services).reduce((pageUpsellings, {
    pageName,
    minimumLicenseRequired,
    component
  }) => {
    if (!license.hasAtLeast(minimumLicenseRequired)) {
      pageUpsellings[pageName] = (0, _services.withServicesProvider)(component, services);
    }
    return pageUpsellings;
  }, {});
  const upsellingSectionsToRegister = upsellingSections.reduce((sectionUpsellings, {
    id,
    minimumLicenseRequired,
    component
  }) => {
    if (!license.hasAtLeast(minimumLicenseRequired)) {
      sectionUpsellings[id] = component;
    }
    return sectionUpsellings;
  }, {});
  const upsellingMessagesToRegister = upsellingMessages.reduce((messagesUpsellings, {
    id,
    minimumLicenseRequired,
    message
  }) => {
    if (!license.hasAtLeast(minimumLicenseRequired)) {
      messagesUpsellings[id] = message;
    }
    return messagesUpsellings;
  }, {});
  upselling.setPages(upsellingPagesToRegister);
  upselling.setSections(upsellingSectionsToRegister);
  upselling.setMessages(upsellingMessagesToRegister);
};

// Upsellings for entire pages, linked to a SecurityPageName
exports.registerUpsellings = registerUpsellings;
const upsellingPages = services => [
// It is highly advisable to make use of lazy loaded components to minimize bundle size.
{
  pageName: _common.SecurityPageName.entityAnalytics,
  minimumLicenseRequired: 'platinum',
  component: () => /*#__PURE__*/_react.default.createElement(EntityAnalyticsUpsellingLazy, {
    requiredLicense: "Platinum",
    subscriptionUrl: services.application.getUrlForApp('management', {
      path: 'stack/license_management'
    })
  })
}];

// Upsellings for sections, linked by arbitrary ids
exports.upsellingPages = upsellingPages;
const upsellingSections = [
  // It is highly advisable to make use of lazy loaded components to minimize bundle size.
];

// Upsellings for sections, linked by arbitrary ids
exports.upsellingSections = upsellingSections;
const upsellingMessages = [{
  id: 'investigation_guide',
  minimumLicenseRequired: 'platinum',
  message: (0, _messages.UPGRADE_INVESTIGATION_GUIDE)('Platinum')
}, {
  id: 'alert_assignments',
  minimumLicenseRequired: 'platinum',
  message: (0, _messages.UPGRADE_ALERT_ASSIGNMENTS)('Platinum')
}, {
  id: 'alert_suppression_rule_form',
  minimumLicenseRequired: 'platinum',
  message: (0, _messages.ALERT_SUPPRESSION_RULE_FORM)('Platinum')
}, {
  id: 'alert_suppression_rule_details',
  minimumLicenseRequired: 'platinum',
  message: _messages.ALERT_SUPPRESSION_RULE_DETAILS
}];
exports.upsellingMessages = upsellingMessages;