/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.security_bundle_jsonpfunction=window.security_bundle_jsonpfunction||[]).push([[13],{308:function(e,s,t){"use strict";t.r(s),t.d(s,"UsersGridPage",(function(){return users_grid_page_UsersGridPage}));var a=t(7),r=t.n(a),n=t(1),i=t.n(n),o=t(3),d=t(2),u=t.n(d),l=t(4),c=t(6),g=t(5),m=t(73),h=t(98),p=(t(82),t(59)),j=t(0);class confirm_delete_users_ConfirmDeleteUsers extends d.Component{constructor(...e){super(...e),i()(this,"deleteUsers",(()=>{const{usersToDelete:e,callback:s,userAPIClient:t,notifications:a}=this.props,r=[];Object(p.asyncForEach)(e,(async e=>{try{await t.deleteUser(e),a.toasts.addSuccess(l.i18n.translate("xpack.security.management.users.confirmDelete.userSuccessfullyDeletedNotificationMessage",{defaultMessage:"Deleted user {username}",values:{username:e}}))}catch(s){r.push(e),a.toasts.addDanger(l.i18n.translate("xpack.security.management.users.confirmDelete.userDeletingErrorNotificationMessage",{defaultMessage:"Error deleting user {username}",values:{username:e}}))}})).then((()=>{s&&s(e,r)}))}))}render(){const{usersToDelete:e,onCancel:s}=this.props,t=e.length>1,a=t?l.i18n.translate("xpack.security.management.users.confirmDelete.deleteMultipleUsersTitle",{defaultMessage:"Delete {userLength} users",values:{userLength:e.length}}):l.i18n.translate("xpack.security.management.users.confirmDelete.deleteOneUserTitle",{defaultMessage:"Delete user {userLength}",values:{userLength:e[0]}});return Object(j.jsx)(o.EuiConfirmModal,{title:a,onCancel:s,onConfirm:this.deleteUsers,cancelButtonText:l.i18n.translate("xpack.security.management.users.confirmDelete.cancelButtonLabel",{defaultMessage:"Cancel"}),confirmButtonText:l.i18n.translate("xpack.security.management.users.confirmDelete.confirmButtonLabel",{defaultMessage:"Delete"}),buttonColor:"danger"},Object(j.jsx)("div",null,t?Object(j.jsx)(d.Fragment,null,Object(j.jsx)("p",null,Object(j.jsx)(c.FormattedMessage,{id:"xpack.security.management.users.confirmDelete.removingUsersDescription",defaultMessage:"You are about to delete these users:"})),Object(j.jsx)("ul",null,e.map((e=>Object(j.jsx)("li",{key:e},e))))):null,Object(j.jsx)("p",null,Object(j.jsx)(c.FormattedMessage,{id:"xpack.security.management.users.confirmDelete.removingUsersWarningMessage",defaultMessage:"This operation cannot be undone."}))))}}var b=t(71);class users_grid_page_UsersGridPage extends d.Component{constructor(e){super(e),i()(this,"handleDelete",((e,s)=>{const{users:t}=this.state,a=t.filter((({username:t})=>!e.includes(t)||s.includes(t)));this.setState({selection:[],showDeleteConfirmation:!1,users:a,visibleUsers:this.getVisibleUsers(a,this.state.filter,this.state.includeReservedUsers)})})),i()(this,"getVisibleUsers",((e,s,t)=>e.filter((({username:e,roles:a,full_name:r="",email:n="",metadata:i={}})=>{const o=`${e} ${a.join(" ")} ${r} ${n}`.toLowerCase(),d=s.toLowerCase();return-1!==o.indexOf(d)&&(t||!i._reserved)})))),i()(this,"onIncludeReservedUsersChange",(e=>{this.setState({includeReservedUsers:e.target.checked,visibleUsers:this.getVisibleUsers(this.state.users,this.state.filter,e.target.checked)})})),i()(this,"getUserStatusBadges",(e=>{const s=e.enabled,t=Object(b.c)(e),a=Object(b.b)(e),r=[];return s||r.push(Object(j.jsx)(m.b,{"data-test-subj":"userDisabled"})),t&&r.push(Object(j.jsx)(m.d,{"data-test-subj":"userReserved",tooltipContent:Object(j.jsx)(c.FormattedMessage,{id:"xpack.security.management.users.reservedUserBadgeTooltip",defaultMessage:"Reserved users are built-in and cannot be edited or removed."})})),a&&r.push(Object(j.jsx)(m.a,{"data-test-subj":"userDeprecated",tooltipContent:Object(b.a)(e)})),Object(j.jsx)(o.EuiFlexGroup,{gutterSize:"s",wrap:!0},r.map(((e,s)=>Object(j.jsx)(o.EuiFlexItem,{key:s,grow:!1},e))))})),i()(this,"onCancelDelete",(()=>{this.setState({showDeleteConfirmation:!1})})),this.state={users:[],visibleUsers:[],roles:[],selection:[],showDeleteConfirmation:!1,permissionDenied:!1,filter:"",includeReservedUsers:!0,isTableLoading:!1}}componentDidMount(){this.loadUsersAndRoles()}render(){const{roles:e,permissionDenied:s,showDeleteConfirmation:t,selection:a}=this.state;if(s)return Object(j.jsx)(o.EuiFlexGroup,{gutterSize:"none"},Object(j.jsx)(o.EuiPageSection,{alignment:"center",color:"danger"},Object(j.jsx)(o.EuiEmptyPrompt,{iconType:"securityApp",title:Object(j.jsx)("h1",null,Object(j.jsx)(c.FormattedMessage,{id:"xpack.security.management.users.deniedPermissionTitle",defaultMessage:"You need permission to manage users"})),body:Object(j.jsx)("p",{"data-test-subj":"permissionDeniedMessage"},Object(j.jsx)(c.FormattedMessage,{id:"xpack.security.management.users.permissionDeniedToManageUsersDescription",defaultMessage:"Contact your system administrator."}))})));const n=[{field:"username",name:l.i18n.translate("xpack.security.management.users.userNameColumnName",{defaultMessage:"User Name"}),sortable:!0,render:e=>Object(j.jsx)(o.EuiLink,r()({"data-test-subj":"userRowUserName"},Object(g.reactRouterNavigate)(this.props.history,`/edit/${encodeURIComponent(e)}`)),e)},{field:"full_name",name:l.i18n.translate("xpack.security.management.users.fullNameColumnName",{defaultMessage:"Full Name"}),sortable:!0,truncateText:!0,render:e=>Object(j.jsx)("div",{"data-test-subj":"userRowFullName"},e)},{field:"email",name:l.i18n.translate("xpack.security.management.users.emailAddressColumnName",{defaultMessage:"Email Address"}),sortable:!0,truncateText:!0,render:e=>Object(j.jsx)("div",{"data-test-subj":"userRowEmail"},e)},{field:"roles",name:l.i18n.translate("xpack.security.management.users.rolesColumnName",{defaultMessage:"Roles"}),width:"30%",render:s=>{const t=s.map(((s,t)=>{var a;const r=null!==(a=null==e?void 0:e.find((e=>e.name===s)))&&void 0!==a?a:s;return Object(j.jsx)(o.EuiFlexItem,{grow:!1,key:s},Object(j.jsx)(h.a,{role:r,navigateToApp:this.props.navigateToApp}))}));return Object(j.jsx)(o.EuiFlexGroup,{"data-test-subj":"userRowRoles",gutterSize:"s",wrap:!0},t)}},{field:"metadata",name:l.i18n.translate("xpack.security.management.users.statusColumnName",{defaultMessage:"Status"}),width:"10%",sortable:({metadata:e})=>Boolean(e&&e._reserved),description:l.i18n.translate("xpack.security.management.users.reservedColumnDescription",{defaultMessage:"Reserved users are built-in and cannot be removed. Only the password can be changed."}),render:(e,s)=>this.getUserStatusBadges(s)}],i={itemId:"username",selectable:e=>!(e.metadata&&e.metadata._reserved),selectableMessage:e=>e?"":"User is a system user",onSelectionChange:e=>this.setState({selection:e})},d={toolsLeft:this.renderToolsLeft(),toolsRight:this.renderToolsRight(),box:{incremental:!0,"data-test-subj":"searchUsers"},onChange:e=>{this.setState({filter:e.queryText,visibleUsers:this.getVisibleUsers(this.state.users,e.queryText,this.state.includeReservedUsers)})}};return Object(j.jsx)(u.a.Fragment,null,Object(j.jsx)(o.EuiPageHeader,{bottomBorder:!0,pageTitle:Object(j.jsx)(c.FormattedMessage,{id:"xpack.security.management.users.usersTitle",defaultMessage:"Users"}),rightSideItems:this.props.readOnly?void 0:[Object(j.jsx)(o.EuiButton,r()({"data-test-subj":"createUserButton"},Object(g.reactRouterNavigate)(this.props.history,"/create"),{fill:!0,iconType:"plusInCircleFilled"}),Object(j.jsx)(c.FormattedMessage,{id:"xpack.security.management.users.createNewUserButtonLabel",defaultMessage:"Create user"}))]}),Object(j.jsx)(o.EuiSpacer,{size:"l"}),t?Object(j.jsx)(confirm_delete_users_ConfirmDeleteUsers,{onCancel:this.onCancelDelete,usersToDelete:a.map((e=>e.username)),callback:this.handleDelete,userAPIClient:this.props.userAPIClient,notifications:this.props.notifications}):null,Object(j.jsx)(o.EuiInMemoryTable,{itemId:"username",tableCaption:l.i18n.translate("xpack.security.management.users.tableCaption",{defaultMessage:"Users"}),rowHeader:"username",columns:n,selection:this.props.readOnly?void 0:i,pagination:{initialPageSize:20,pageSizeOptions:[10,20,50,100]},items:this.state.visibleUsers,loading:this.state.isTableLoading,search:d,sorting:{sort:{field:"username",direction:"asc"}},rowProps:()=>({"data-test-subj":"userRow"}),isSelectable:!0}))}async loadUsersAndRoles(){try{this.setState({isTableLoading:!0});const[e,s]=await Promise.all([this.props.userAPIClient.getUsers(),this.props.rolesAPIClient.getRoles()]);this.setState({isTableLoading:!1,users:e,roles:s,visibleUsers:this.getVisibleUsers(e,this.state.filter,this.state.includeReservedUsers)})}catch(e){this.setState({permissionDenied:403===e.body.statusCode,isTableLoading:!1}),403!==e.body.statusCode&&this.props.notifications.toasts.addDanger(l.i18n.translate("xpack.security.management.users.fetchingUsersErrorMessage",{defaultMessage:"Error fetching users: {message}",values:{message:e.body.message}}))}}renderToolsLeft(){const{selection:e}=this.state;if(0===e.length)return;const s=e.length;return Object(j.jsx)(o.EuiButton,{"data-test-subj":"deleteUserButton",color:"danger",onClick:()=>this.setState({showDeleteConfirmation:!0})},Object(j.jsx)(c.FormattedMessage,{id:"xpack.security.management.users.deleteUsersButtonLabel",defaultMessage:"Delete {numSelected} user{numSelected, plural, one { } other {s}}",values:{numSelected:s}}))}renderToolsRight(){return Object(j.jsx)(o.EuiSwitch,{"data-test-subj":"showReservedUsersSwitch",label:Object(j.jsx)(c.FormattedMessage,{id:"xpack.security.management.users.showReservedUsersLabel",defaultMessage:"Show reserved users"}),checked:this.state.includeReservedUsers,onChange:this.onIncludeReservedUsersChange})}}i()(users_grid_page_UsersGridPage,"defaultProps",{readOnly:!1})},71:function(e,s,t){"use strict";t.d(s,"c",(function(){return r})),t.d(s,"b",(function(){return n})),t.d(s,"a",(function(){return i}));var a=t(4);const r=e=>{var s,t;return null!==(s=null===(t=e.metadata)||void 0===t?void 0:t._reserved)&&void 0!==s&&s},n=e=>{var s,t;return null!==(s=null===(t=e.metadata)||void 0===t?void 0:t._deprecated)&&void 0!==s&&s},i=e=>{var s,t;const r=null!==(s=null===(t=e.metadata)||void 0===t?void 0:t._deprecated_reason)&&void 0!==s?s:"";return a.i18n.translate("xpack.security.management.users.extendedUserDeprecationNotice",{defaultMessage:"The {username} user is deprecated. {reason}",values:{username:e.username,reason:r}})}},73:function(e,s,t){"use strict";t.d(s,"a",(function(){return o})),t.d(s,"b",(function(){return d})),t.d(s,"c",(function(){return u})),t.d(s,"d",(function(){return l}));var a=t(3),r=(t(2),t(6)),n=t(0);const i=e=>e.tooltipContent?Object(n.jsx)(a.EuiToolTip,{content:e.tooltipContent},e.children):e.children,o=e=>Object(n.jsx)(i,{tooltipContent:e.tooltipContent},Object(n.jsx)(a.EuiBadge,{"data-test-subj":e["data-test-subj"],color:"warning"},Object(n.jsx)(r.FormattedMessage,{id:"xpack.security.management.deprecatedBadge",defaultMessage:"Deprecated"}))),d=e=>Object(n.jsx)(i,{tooltipContent:e.tooltipContent},Object(n.jsx)(a.EuiBadge,{"data-test-subj":e["data-test-subj"],color:"hollow"},Object(n.jsx)(r.FormattedMessage,{id:"xpack.security.management.disabledBadge",defaultMessage:"Disabled"}))),u=e=>Object(n.jsx)(i,{tooltipContent:e.tooltipContent},Object(n.jsx)(a.EuiBadge,{"data-test-subj":e["data-test-subj"],color:"success"},Object(n.jsx)(r.FormattedMessage,{id:"xpack.security.management.enabledBadge",defaultMessage:"Enabled"}))),l=e=>Object(n.jsx)(i,{tooltipContent:e.tooltipContent},Object(n.jsx)(a.EuiBadge,{"data-test-subj":e["data-test-subj"],color:"primary"},Object(n.jsx)(r.FormattedMessage,{id:"xpack.security.management.reservedBadge",defaultMessage:"Reserved"})))},82:function(e,s,t){"use strict";t.d(s,"a",(function(){return change_password_form_ChangePasswordForm}));var a=t(7),r=t.n(a),n=t(1),i=t.n(n),o=t(3),d=t(18),u=t.n(d),l=t(2),c=t(4),g=t(6),m=t(0);class change_password_form_ChangePasswordForm extends l.Component{constructor(e){super(e),i()(this,"getForm",(()=>Object(m.jsx)(o.EuiForm,null,this.props.isUserChangingOwnPassword&&Object(m.jsx)(o.EuiFormRow,r()({},this.validateCurrentPassword(),{fullWidth:!0,label:Object(m.jsx)(g.FormattedMessage,{id:"xpack.security.account.changePasswordForm.currentPasswordLabel",defaultMessage:"Current password"})}),Object(m.jsx)(o.EuiFieldPassword,{autoComplete:"off","data-test-subj":"currentPassword",type:"dual",value:this.state.currentPassword,onChange:this.onCurrentPasswordChange,disabled:this.state.changeInProgress,fullWidth:!0})),Object(m.jsx)(o.EuiFormRow,r()({helpText:Object(m.jsx)(g.FormattedMessage,{id:"xpack.security.account.changePasswordForm.passwordRequirements",defaultMessage:"Use at least 6 characters."})},this.validateNewPassword(),{fullWidth:!0,label:Object(m.jsx)(g.FormattedMessage,{id:"xpack.security.account.changePasswordForm.newPasswordLabel",defaultMessage:"New password"})}),Object(m.jsx)(o.EuiFieldPassword,{autoComplete:"new-password","data-test-subj":"newPassword",type:"dual",value:this.state.newPassword,onChange:this.onNewPasswordChange,disabled:this.state.changeInProgress,fullWidth:!0})),Object(m.jsx)(o.EuiFormRow,r()({},this.validateConfirmPassword(),{fullWidth:!0,label:Object(m.jsx)(g.FormattedMessage,{id:"xpack.security.account.changePasswordForm.confirmPasswordLabel",defaultMessage:"Confirm new password"})}),Object(m.jsx)(o.EuiFieldPassword,{autoComplete:"new-password","data-test-subj":"confirmNewPassword",type:"dual",value:this.state.confirmPassword,onChange:this.onConfirmPasswordChange,disabled:this.state.changeInProgress,fullWidth:!0})),Object(m.jsx)(o.EuiFormRow,null,Object(m.jsx)(o.EuiFlexGroup,{alignItems:"center",responsive:!1},Object(m.jsx)(o.EuiFlexItem,{grow:!1},Object(m.jsx)(o.EuiButton,{onClick:this.onChangePasswordClick,fill:!0,isLoading:this.state.changeInProgress,"data-test-subj":"changePasswordButton"},Object(m.jsx)(g.FormattedMessage,{id:"xpack.security.account.changePasswordForm.saveChangesButtonLabel",defaultMessage:"Change password"}))),Object(m.jsx)(o.EuiFlexItem,{grow:!1},Object(m.jsx)(o.EuiButtonEmpty,{onClick:this.onCancelClick,isDisabled:this.state.changeInProgress},Object(m.jsx)(g.FormattedMessage,{id:"xpack.security.account.changePasswordForm.cancelButtonLabel",defaultMessage:"Reset"})))))))),i()(this,"onCurrentPasswordChange",(e=>{this.setState({currentPassword:e.target.value,currentPasswordError:!1})})),i()(this,"onNewPasswordChange",(e=>{this.setState({newPassword:e.target.value})})),i()(this,"onConfirmPasswordChange",(e=>{this.setState({confirmPassword:e.target.value})})),i()(this,"onCancelClick",(()=>{this.setState({shouldValidate:!1,currentPassword:"",newPassword:"",confirmPassword:"",currentPasswordError:!1,changeInProgress:!1})})),i()(this,"onChangePasswordClick",(async()=>{this.setState({shouldValidate:!0,currentPasswordError:!1},(()=>{const{isInvalid:e}=this.validateForm();e||this.setState({changeInProgress:!0},(()=>this.performPasswordChange()))}))})),i()(this,"validateCurrentPassword",((e=this.state.shouldValidate)=>e&&this.props.isUserChangingOwnPassword?this.state.currentPasswordError?{isInvalid:!0,error:Object(m.jsx)(g.FormattedMessage,{id:"xpack.security.account.changePasswordForm.invalidPassword",defaultMessage:"Current password is incorrect."})}:this.state.currentPassword?{isInvalid:!1}:{isInvalid:!0,error:Object(m.jsx)(g.FormattedMessage,{id:"xpack.security.account.currentPasswordRequired",defaultMessage:"Current password is required."})}:{isInvalid:!1})),i()(this,"validateNewPassword",((e=this.state.shouldValidate)=>{const{newPassword:s}=this.state;return e&&s.length<6?{isInvalid:!0,error:Object(m.jsx)(g.FormattedMessage,{id:"xpack.security.account.passwordLengthDescription",defaultMessage:"Password is too short."})}:{isInvalid:!1}})),i()(this,"validateConfirmPassword",((e=this.state.shouldValidate)=>{const{newPassword:s,confirmPassword:t}=this.state;return e&&s!==t?{isInvalid:!0,error:Object(m.jsx)(g.FormattedMessage,{id:"xpack.security.account.passwordsDoNotMatch",defaultMessage:"Passwords do not match."})}:{isInvalid:!1}})),i()(this,"validateForm",(()=>[this.validateCurrentPassword(!0),this.validateNewPassword(!0),this.validateConfirmPassword(!0)].find((e=>e.isInvalid))||{isInvalid:!1})),i()(this,"performPasswordChange",(async()=>{try{await this.props.userAPIClient.changePassword(this.props.user.username,this.state.newPassword,this.state.currentPassword),this.handleChangePasswordSuccess()}catch(e){this.handleChangePasswordFailure(e)}finally{this.setState({changeInProgress:!1})}})),i()(this,"handleChangePasswordSuccess",(()=>{this.props.notifications.toasts.addSuccess({title:c.i18n.translate("xpack.security.account.changePasswordSuccess",{defaultMessage:"Your password has been changed."}),"data-test-subj":"passwordUpdateSuccess"}),this.setState({currentPasswordError:!1,shouldValidate:!1,newPassword:"",currentPassword:"",confirmPassword:""}),this.props.onChangePassword&&this.props.onChangePassword()})),i()(this,"handleChangePasswordFailure",(e=>{e.body&&403===e.body.statusCode?this.setState({currentPasswordError:!0}):this.props.notifications.toasts.addDanger(c.i18n.translate("xpack.security.management.users.editUser.settingPasswordErrorMessage",{defaultMessage:"Error setting password: {message}",values:{message:u.a.get(e,"body.message")}}))})),this.state={shouldValidate:!1,currentPassword:"",newPassword:"",confirmPassword:"",currentPasswordError:!1,changeInProgress:!1}}render(){return this.getForm()}}},98:function(e,s,t){"use strict";t.d(s,"a",(function(){return i}));var a=t(3),r=(t(2),t(22)),n=t(0);const i=({role:e,navigateToApp:s})=>{let t,i;return"string"==typeof e?(t=Object(n.jsx)("div",null,e),i=`security/roles/edit/${encodeURIComponent(e)}`):Object(r.j)(e)?(t=Object(n.jsx)(a.EuiToolTip,{content:Object(r.e)(e),"data-test-subj":"roleDeprecationTooltip"},Object(n.jsx)("div",null,e.name," ",Object(n.jsx)(a.EuiIcon,{type:"warning",color:"warning",size:"s",className:"eui-alignTop"}))),i=`security/roles/edit/${encodeURIComponent(e.name)}`):(t=Object(n.jsx)("div",null,e.name),i=`security/roles/edit/${encodeURIComponent(e.name)}`),Object(n.jsx)(a.EuiLink,{onClick:()=>s("management",{path:i})},t)}}}]);