"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnauthenticatedPage = UnauthenticatedPage;
exports.renderUnauthenticatedPage = renderUnauthenticatedPage;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _server = require("react-dom/server");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _prompt_page = require("../prompt_page");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function UnauthenticatedPage({
  basePath,
  originalURL,
  buildNumber,
  customBranding
}) {
  return /*#__PURE__*/_react.default.createElement(_prompt_page.PromptPage, {
    buildNumber: buildNumber,
    basePath: basePath,
    title: _i18n.i18n.translate('xpack.security.unauthenticated.pageTitle', {
      defaultMessage: 'We hit an authentication error'
    }),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.unauthenticated.errorDescription",
      defaultMessage: "Try logging in again, and if the problem persists, contact your system administrator."
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: originalURL,
      "data-test-subj": "logInButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.unauthenticated.loginButtonLabel",
      defaultMessage: "Log in"
    }))],
    customBranding: customBranding
  });
}
function renderUnauthenticatedPage(props) {
  return (0, _server.renderToStaticMarkup)( /*#__PURE__*/_react.default.createElement(UnauthenticatedPage, props));
}