"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrimaryFeaturePrivilege = void 0;
var _kibana_privilege = require("./kibana_privilege");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PrimaryFeaturePrivilege extends _kibana_privilege.KibanaPrivilege {
  constructor(id, config, actions = []) {
    super(id, actions);
    this.config = config;
    this.actions = actions;
  }
  isMinimalFeaturePrivilege() {
    return this.id.startsWith('minimal_');
  }
  getMinimalPrivilegeId() {
    if (this.isMinimalFeaturePrivilege()) {
      return this.id;
    }
    return `minimal_${this.id}`;
  }
  get requireAllSpaces() {
    var _this$config$requireA;
    return (_this$config$requireA = this.config.requireAllSpaces) !== null && _this$config$requireA !== void 0 ? _this$config$requireA : false;
  }
  get disabled() {
    var _this$config$disabled;
    return (_this$config$disabled = this.config.disabled) !== null && _this$config$disabled !== void 0 ? _this$config$disabled : false;
  }
}
exports.PrimaryFeaturePrivilege = PrimaryFeaturePrivilege;