"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaPrivilege = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class KibanaPrivilege {
  constructor(id, actions = []) {
    this.id = id;
    this.actions = actions;
  }
  get name() {
    return _lodash.default.upperFirst(this.id);
  }
  grantsPrivilege(candidatePrivilege) {
    return this.checkActions(this.actions, candidatePrivilege.actions).hasAllRequested;
  }
  checkActions(knownActions, candidateActions) {
    const missing = candidateActions.filter(action => !knownActions.includes(action));
    const hasAllRequested = knownActions.length > 0 && candidateActions.length > 0 && missing.length === 0;
    return {
      missing,
      hasAllRequested
    };
  }
}
exports.KibanaPrivilege = KibanaPrivilege;