"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeSummaryTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _privilege_summary_calculator = require("./privilege_summary_calculator");
var _privilege_summary_expanded_row = require("./privilege_summary_expanded_row");
var _space_column_header = require("./space_column_header");
var _constants = require("../../../../../../../common/constants");
var _privilege_utils = require("../../../privilege_utils");
var _feature_table_cell = require("../feature_table_cell");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getColumnKey(entry) {
  return `privilege_entry_${entry.spaces.join('|')}`;
}
function showPrivilege(allSpacesSelected, primaryFeature) {
  if ((primaryFeature === null || primaryFeature === void 0 ? void 0 : primaryFeature.name) == null || primaryFeature !== null && primaryFeature !== void 0 && primaryFeature.disabled || primaryFeature.requireAllSpaces && !allSpacesSelected) {
    return 'None';
  }
  return primaryFeature === null || primaryFeature === void 0 ? void 0 : primaryFeature.name;
}
const PrivilegeSummaryTable = props => {
  const [expandedFeatures, setExpandedFeatures] = (0, _react.useState)([]);
  const featureCategories = (0, _react.useMemo)(() => {
    const featureCategoryMap = new Map();
    props.kibanaPrivileges.getSecuredFeatures().filter(feature => feature.privileges != null || feature.reserved != null).forEach(feature => {
      if (!featureCategoryMap.has(feature.category.id)) {
        featureCategoryMap.set(feature.category.id, []);
      }
      featureCategoryMap.get(feature.category.id).push(feature);
    });
    return featureCategoryMap;
  }, [props.kibanaPrivileges]);
  const calculator = new _privilege_summary_calculator.PrivilegeSummaryCalculator(props.kibanaPrivileges, props.role);
  const toggleExpandedFeature = featureId => {
    if (expandedFeatures.includes(featureId)) {
      setExpandedFeatures(expandedFeatures.filter(ef => ef !== featureId));
    } else {
      setExpandedFeatures([...expandedFeatures, featureId]);
    }
  };
  const featureColumn = {
    name: 'Feature',
    field: 'feature',
    render: feature => {
      return /*#__PURE__*/_react.default.createElement(_feature_table_cell.FeatureTableCell, {
        feature: feature
      });
    }
  };
  const rowExpanderColumn = {
    align: 'right',
    width: '40px',
    isExpander: true,
    field: 'featureId',
    name: '',
    render: (featureId, record) => {
      const feature = record.feature;
      const hasSubFeaturePrivileges = feature.getSubFeaturePrivileges().length > 0;
      if (!hasSubFeaturePrivileges) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => toggleExpandedFeature(featureId),
        "data-test-subj": `expandPrivilegeSummaryRow`,
        "aria-label": expandedFeatures.includes(featureId) ? 'Collapse' : 'Expand',
        iconType: expandedFeatures.includes(featureId) ? 'arrowUp' : 'arrowDown'
      });
    }
  };
  const rawKibanaPrivileges = [...props.role.kibana].sort((entry1, entry2) => {
    if ((0, _privilege_utils.isGlobalPrivilegeDefinition)(entry1)) {
      return -1;
    }
    if ((0, _privilege_utils.isGlobalPrivilegeDefinition)(entry2)) {
      return 1;
    }
    return 0;
  });
  const privilegeColumns = rawKibanaPrivileges.map(entry => {
    const key = getColumnKey(entry);
    return {
      name: /*#__PURE__*/_react.default.createElement(_space_column_header.SpaceColumnHeader, {
        entry: entry,
        spaces: props.spaces,
        spacesApiUi: props.spacesApiUi
      }),
      field: key,
      render: (kibanaPrivilege, record) => {
        const {
          primary,
          hasCustomizedSubFeaturePrivileges
        } = kibanaPrivilege[record.featureId];
        let iconTip = null;
        if (hasCustomizedSubFeaturePrivileges) {
          iconTip = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
            size: "s",
            type: "iInCircle",
            content: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.security.management.editRole.privilegeSummary.additionalPrivilegesGrantedIconTip",
              defaultMessage: "Additional privileges granted. Expand this row for more information."
            }))
          });
        } else {
          iconTip = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            size: "s",
            type: "empty"
          });
        }
        return /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": `privilegeColumn ${hasCustomizedSubFeaturePrivileges ? 'additionalPrivilegesGranted' : ''}`
        }, showPrivilege(props.spaces.some(space => space.id === _constants.ALL_SPACES_ID), primary), ' ', iconTip);
      }
    };
  });
  const columns = [];
  if (props.canCustomizeSubFeaturePrivileges) {
    columns.push(rowExpanderColumn);
  }
  columns.push(featureColumn, ...privilegeColumns);
  const privileges = rawKibanaPrivileges.reduce((acc, entry) => {
    return {
      ...acc,
      [getColumnKey(entry)]: calculator.getEffectiveFeaturePrivileges(entry)
    };
  }, {});
  const accordions = [];
  featureCategories.forEach(featuresInCategory => {
    const {
      category
    } = featuresInCategory[0];
    const buttonContent = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-test-subj": `featureCategoryButton_${category.id}`,
      alignItems: 'center',
      responsive: false,
      gutterSize: "m"
    }, category.euiIconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: category.euiIconType
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", {
      className: "eui-displayInlineBlock"
    }, category.label))));
    const categoryItems = featuresInCategory.map(feature => {
      return {
        feature,
        featureId: feature.id,
        ...privileges
      };
    });
    accordions.push( /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: `privilegeSummaryFeatureCategory_${category.id}`,
      "data-test-subj": `privilegeSummaryFeatureCategory_${category.id}`,
      key: category.id,
      buttonContent: buttonContent,
      initialIsOpen: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      columns: columns,
      items: categoryItems,
      itemId: "featureId",
      rowProps: record => {
        return {
          'data-test-subj': `summaryTableRow-${record.featureId}`
        };
      },
      itemIdToExpandedRowMap: expandedFeatures.reduce((acc, featureId) => {
        return {
          ...acc,
          [featureId]: /*#__PURE__*/_react.default.createElement(_privilege_summary_expanded_row.PrivilegeSummaryExpandedRow, {
            feature: props.kibanaPrivileges.getSecuredFeature(featureId),
            effectiveFeaturePrivileges: Object.values(privileges).map(p => p[featureId])
          })
        };
      }, {})
    })));
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, accordions.map((a, idx) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: idx
  }, a, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))));
};
exports.PrivilegeSummaryTable = PrivilegeSummaryTable;