"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MappingInfoPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _role_selector = require("../role_selector");
var _role_mapping_validation = require("../services/role_mapping_validation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MappingInfoPanel extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getRoleMappingName", () => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingNameFormGroupTitle",
          defaultMessage: "Mapping name"
        })),
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingNameFormGroupHelpText",
          defaultMessage: "A unique name used to identify this role mapping."
        }),
        fullWidth: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingNameFormRowTitle",
          defaultMessage: "Name"
        }),
        fullWidth: true
      }, this.props.validateForm && (0, _role_mapping_validation.validateRoleMappingName)(this.props.roleMapping)), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        name: 'name',
        value: this.props.roleMapping.name || '',
        onChange: this.onNameChange,
        "data-test-subj": 'roleMappingFormNameInput',
        disabled: this.props.mode === 'edit' || this.props.mode === 'view'
      })));
    });
    (0, _defineProperty2.default)(this, "getRolesOrRoleTemplatesSelector", () => {
      if (this.state.rolesMode === 'roles') {
        return this.getRolesSelector();
      }
      return this.getRoleTemplatesSelector();
    });
    (0, _defineProperty2.default)(this, "getRolesSelector", () => {
      const validationFunction = () => {
        if (!this.props.validateForm) {
          return {};
        }
        return (0, _role_mapping_validation.validateRoleMappingRoles)(this.props.roleMapping);
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingRolesFormRowTitle",
          defaultMessage: "Roles"
        })),
        description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingRolesFormRowHelpText",
          defaultMessage: "Assign roles to your users."
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }), this.getSwitchToRoleTemplateButton()),
        fullWidth: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        fullWidth: true
      }, validationFunction()), /*#__PURE__*/_react.default.createElement(_role_selector.RoleSelector, {
        "data-test-subj": 'roleMappingFormRoleSelector',
        rolesAPIClient: this.props.rolesAPIClient,
        roleMapping: this.props.roleMapping,
        mode: this.state.rolesMode,
        canUseInlineScripts: this.props.canUseInlineScripts,
        canUseStoredScripts: this.props.canUseStoredScripts,
        onChange: roleMapping => this.props.onChange(roleMapping),
        readOnly: this.props.mode === 'view'
      })));
    });
    (0, _defineProperty2.default)(this, "getSwitchToRoleTemplateButton", () => {
      if (this.props.mode !== 'view') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "switchToRoleTemplatesButton",
          onClick: () => {
            this.onRolesModeChange('templates');
          }
        }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.switchToRoleTemplates",
          defaultMessage: "Switch to role templates"
        }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "s",
          type: "inputOutput"
        })));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "getRoleTemplatesSelector", () => {
      const validationFunction = () => {
        if (!this.props.validateForm) {
          return {};
        }
        return (0, _role_mapping_validation.validateRoleMappingRoleTemplates)(this.props.roleMapping);
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingRoleTemplatesFormRowTitle",
          defaultMessage: "Role templates"
        })),
        description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingRoleTemplatesFormRowHelpText",
          defaultMessage: "Create templates that describe the roles to assign to your users."
        }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: this.props.docLinks.links.apis.createRoleMappingTemplates,
          external: true,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingRoleTemplatesFormRowLearnMore",
          defaultMessage: "Learn about role templates"
        }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }), this.getSwitchToRolesButton()),
        fullWidth: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        fullWidth: true
      }, validationFunction()), /*#__PURE__*/_react.default.createElement(_role_selector.RoleSelector, {
        "data-test-subj": 'roleMappingFormTemplateSelector',
        rolesAPIClient: this.props.rolesAPIClient,
        roleMapping: this.props.roleMapping,
        mode: this.state.rolesMode,
        canUseInlineScripts: this.props.canUseInlineScripts,
        canUseStoredScripts: this.props.canUseStoredScripts,
        onChange: roleMapping => this.props.onChange(roleMapping),
        readOnly: this.props.mode === 'view'
      })));
    });
    (0, _defineProperty2.default)(this, "getSwitchToRolesButton", () => {
      if (this.props.mode !== 'view') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => {
            this.onRolesModeChange('roles');
          },
          "data-test-subj": "switchToRolesButton"
        }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.switchToRoles",
          defaultMessage: "Switch to roles"
        }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "s",
          type: "inputOutput"
        })));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "getEnabledSwitch", () => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingEnabledFormRowTitle",
          defaultMessage: "Enable mapping"
        })),
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingEnabledFormRowHelpText",
          defaultMessage: "Map roles to users based on their username, groups, and other metadata. When false, ignore mappings."
        }),
        fullWidth: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingEnabledFormRowLabel",
          defaultMessage: "Enable mapping"
        }),
        fullWidth: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        name: 'enabled',
        label: _i18n.i18n.translate('xpack.security.management.editRoleMapping.roleMappingEnabledLabel', {
          defaultMessage: 'Enable mapping'
        }),
        showLabel: false,
        "data-test-subj": "roleMappingsEnabledSwitch",
        checked: this.props.roleMapping.enabled,
        onChange: e => {
          this.props.onChange({
            ...this.props.roleMapping,
            enabled: e.target.checked
          });
        },
        disabled: this.props.mode === 'view'
      })));
    });
    (0, _defineProperty2.default)(this, "onNameChange", e => {
      const name = e.target.value;
      this.props.onChange({
        ...this.props.roleMapping,
        name
      });
    });
    (0, _defineProperty2.default)(this, "onRolesModeChange", rolesMode => {
      const canUseTemplates = this.props.canUseInlineScripts || this.props.canUseStoredScripts;
      if (rolesMode === 'templates' && canUseTemplates) {
        // Create blank template as a starting point
        const defaultTemplate = this.props.canUseInlineScripts ? {
          template: {
            source: ''
          }
        } : {
          template: {
            id: ''
          }
        };
        this.props.onChange({
          ...this.props.roleMapping,
          roles: [],
          role_templates: [defaultTemplate]
        });
      }
      this.setState({
        rolesMode
      });
    });
    this.state = {
      rolesMode: props.roleMapping.role_templates && props.roleMapping.role_templates.length > 0 ? 'templates' : 'roles'
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRoleMapping.roleMappingTitle",
      defaultMessage: "Role mapping"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), this.getRoleMappingName(), this.getEnabledSwitch(), this.getRolesOrRoleTemplatesSelector());
  }
}
exports.MappingInfoPanel = MappingInfoPanel;