"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overwrittenSessionApp = void 0;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const overwrittenSessionApp = Object.freeze({
  id: 'security_overwritten_session',
  create({
    application,
    authc,
    getStartServices
  }) {
    application.register({
      id: this.id,
      title: _i18n.i18n.translate('xpack.security.overwrittenSessionAppTitle', {
        defaultMessage: 'Overwritten Session'
      }),
      chromeless: true,
      appRoute: '/security/overwritten_session',
      async mount({
        element,
        theme$
      }) {
        const [[coreStart], {
          renderOverwrittenSessionPage
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./overwritten_session_page')))]);
        return renderOverwrittenSessionPage(coreStart.i18n, {
          element,
          theme$
        }, {
          authc,
          basePath: coreStart.http.basePath
        });
      }
    });
  }
});
exports.overwrittenSessionApp = overwrittenSessionApp;